% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rimse.R
\name{rimse}
\alias{rimse}
\title{Root Integrated Mean Squared Difference Between FMP IRFs}
\usage{
rimse(bvec1, bvec2, c1 = 0, d1 = 1, c2 = 0, d2 = 1, int = int_mat())
}
\arguments{
\item{bvec1}{Either a vector of FMP item parameters or a function
corresponding to a non-FMP IRF. Functions should have exactly one argument,
corresponding to the latent trait.}

\item{bvec2}{Either a vector of FMP item parameters or a function
corresponding to a non-FMP IRF. Functions should have exactly one argument,
corresponding to the latent trait.}

\item{c1}{Lower asymptote parameter for bvec1.
Ignored if bvec1 is a function.}

\item{d1}{Upper asymptote parameter for bvec1.
Ignored if bvec1 is a function.}

\item{c2}{Lower asymptote parameter for bvec2.
Ignored if bvec2 is a function.}

\item{d2}{Upper asymptote parameter for bvec2.
Ignored if bvec2 is a function.}

\item{int}{Matrix with two columns, used for numerical integration.
Column 1 is a grid of theta values, column 2 are normalized densities
associated with the column 1 values}
}
\value{
Root integrated mean squared difference between two IRFs.
}
\description{
Compute the root integrated mean squared error (RIMSE) between two FMP IRFs.
}
\examples{

set.seed(2342)
bmat <- sim_bmat(n_items = 1, k = 2)$bmat

theta <- rnorm(500)
dat <- sim_data(bmat = bmat, theta = theta)

# k = 0
fmp0 <- fmp_1(dat = dat, k = 0, tsur = theta)

# k = 1
fmp1 <- fmp_1(dat = dat, k = 1, tsur = theta)

## compare estimated curves to the data-generating curve
rimse(fmp0$bmat, bmat)
rimse(fmp1$bmat, bmat)


}
\references{
Ramsay, J. O. (1991). Kernel smoothing approaches to
nonparametric item characteristic curve estimation. \emph{Psychometrika},
\emph{56}, 611--630. \doi{10.1007/BF02294494}
}
