% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_modeler.R
\name{residuals.modeler}
\alias{residuals.modeler}
\title{Extract residuals from a \code{modeler} object}
\usage{
\method{residuals}{modeler}(object, ...)
}
\arguments{
\item{object}{An object of class `modeler`}

\item{...}{Additional parameters for future functionality.}
}
\value{
A numeric vector of residuals
}
\description{
Extract residuals from a \code{modeler} object
}
\examples{
library(flexFitR)
data(dt_potato)
mod_1 <- dt_potato |>
  modeler(
    x = DAP,
    y = Canopy,
    grp = Plot,
    fn = "fn_linear_sat",
    parameters = c(t1 = 45, t2 = 80, k = 0.9),
    subset = c(15, 2, 45)
  )
residuals(mod_1)
}
\author{
Johan Aparicio [aut]
}
