% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SL.ranger.imp.R
\name{SL.ranger.imp}
\alias{SL.ranger.imp}
\title{Super Learner wrapper for a ranger object with variable importance}
\usage{
SL.ranger.imp(
  Y,
  X,
  newX,
  family,
  obsWeights = rep(1, length(Y)),
  num.trees = 500,
  mtry = floor(sqrt(ncol(X))),
  write.forest = TRUE,
  probability = family$family == "binomial",
  min.node.size = ifelse(family$family == "gaussian", 5, 1),
  replace = TRUE,
  sample.fraction = ifelse(replace, 1, 0.632),
  num.threads = 1,
  verbose = FALSE,
  importance = "impurity",
  ...
)
}
\arguments{
\item{Y}{Outcome variable}

\item{X}{Training dataframe}

\item{newX}{Test dataframe}

\item{family}{Gaussian or binomial}

\item{obsWeights}{Observation-level weights}

\item{num.trees}{Number of trees.}

\item{mtry}{Number of variables to possibly split at in each node. Default is
the (rounded down) square root of the number variables.}

\item{write.forest}{Save ranger.forest object, required for prediction. Set
to FALSE to reduce memory usage if no prediction intended.}

\item{probability}{Grow a probability forest as in Malley et al. (2012).}

\item{min.node.size}{Minimal node size. Default 1 for classification, 5 for
regression, 3 for survival, and 10 for probability.}

\item{replace}{Sample with replacement.}

\item{sample.fraction}{Fraction of observations to sample. Default is 1 for
sampling with replacement and 0.632 for sampling without replacement.}

\item{num.threads}{Number of threads to use.}

\item{verbose}{If TRUE, display additional output during execution.}

\item{importance}{Variable importance mode, one of 'none', 'impurity', 'impurity_corrected', 'permutation'. The 'impurity' measure is the Gini index for classification, the variance of the responses for regression and the sum of test statistics (see \code{splitrule}) for survival.}

\item{...}{Any additional arguments, not currently used.}
}
\value{
a named list with elements \code{pred} (predictions on \code{newX}) and \code{fit} (the fitted \code{ranger} object).
}
\description{
Super Learner wrapper for a ranger object with variable importance
}
\examples{
data("biomarkers")
# subset to complete cases for illustration
cc <- complete.cases(biomarkers)
dat_cc <- biomarkers[cc, ]
# use only the mucinous outcome, not the high-malignancy outcome
y <- dat_cc$mucinous
x <- dat_cc[, !(names(dat_cc) \%in\% c("mucinous", "high_malignancy"))]
feature_nms <- names(x)
# get the fit
set.seed(20231129)
fit <- SL.ranger.imp(Y = y, X = x, newX = x, family = binomial())
fit
}
\references{
Breiman, L. (2001). Random forests. Machine learning 45:5-32.

Wright, M. N. & Ziegler, A. (2016). ranger: A Fast Implementation of Random
Forests for High Dimensional Data in C++ and R. Journal of Statistical
Software, in press. http://arxiv.org/abs/1508.04409.
}
\seealso{
\code{\link[SuperLearner]{SL.ranger}} \code{\link[ranger]{ranger}}
  \code{\link[ranger]{predict.ranger}}
}
