% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_table.R
\name{remove_right}
\alias{remove_right}
\alias{remove_right.pivot_table}
\title{Remove right columns from a pivot table}
\usage{
remove_right(pt, n)

\method{remove_right}{pivot_table}(pt, n)
}
\arguments{
\item{pt}{A \code{pivot_table} object.}

\item{n}{A number, number of columns to remove.}
}
\value{
A \code{pivot_table} object.
}
\description{
Remove right columns from the pivot table represented by the object.
}
\details{
A pivot table should only contain label rows and columns, and an array of
values, usually numeric data.

All columns not belonging to the pivot table must be removed.

This function is very useful because it is not necessary to know the number
of columns in the table.
}
\examples{

pt <- pt_ex |> remove_right(3)

}
\seealso{
\code{\link{pivot_table}}

Other pivot table transformation functions: 
\code{\link{extract_labels}()},
\code{\link{fill_labels}()},
\code{\link{fill_values}()},
\code{\link{remove_agg}()},
\code{\link{remove_bottom}()},
\code{\link{remove_cols}()},
\code{\link{remove_empty}()},
\code{\link{remove_k}()},
\code{\link{remove_left}()},
\code{\link{remove_rows}()},
\code{\link{remove_top}()},
\code{\link{replace_dec}()},
\code{\link{unpivot}()}
}
\concept{pivot table transformation functions}
