% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decoder.R
\name{Decoder}
\alias{Decoder}
\title{Decoder}
\value{
invisible(NULL)
}
\description{
Decoder

Decoder
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{ptr}}{set and get the pointer to a Decoder instance.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Decoder-new}{\code{Decoder$new()}}
\item \href{#method-Decoder-decode}{\code{Decoder$decode()}}
\item \href{#method-Decoder-prune}{\code{Decoder$prune()}}
\item \href{#method-Decoder-n_decoded_frames_in_buffer}{\code{Decoder$n_decoded_frames_in_buffer()}}
\item \href{#method-Decoder-get_best_hypothesis}{\code{Decoder$get_best_hypothesis()}}
\item \href{#method-Decoder-get_all_final_hypothesis}{\code{Decoder$get_all_final_hypothesis()}}
\item \href{#method-Decoder-clone}{\code{Decoder$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Decoder-new"></a>}}
\if{latex}{\out{\hypertarget{method-Decoder-new}{}}}
\subsection{Method \code{new()}}{
Decoder is a base class and cannot be initialized directly. It is inherited
by other LM classes shuch as KenLM and ZeroLM.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Decoder$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Decoder-decode"></a>}}
\if{latex}{\out{\hypertarget{method-Decoder-decode}{}}}
\subsection{Method \code{decode()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Decoder$decode(emissions, T, N)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{emissions}}{the emissions. Dimension (Batch=1, Time, Ntokens)}

\item{\code{T}}{an integer. Number of tokens (Ntokens).}

\item{\code{N}}{an integer. Number of timesteps (Time).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisible(NULL)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Decoder-prune"></a>}}
\if{latex}{\out{\hypertarget{method-Decoder-prune}{}}}
\subsection{Method \code{prune()}}{
Prune the hypothesis space
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Decoder$prune(lookBack = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lookBack}}{an integer. Number of frames to look back.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisible(NULL)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Decoder-n_decoded_frames_in_buffer"></a>}}
\if{latex}{\out{\hypertarget{method-Decoder-n_decoded_frames_in_buffer}{}}}
\subsection{Method \code{n_decoded_frames_in_buffer()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Decoder$n_decoded_frames_in_buffer()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
an integer
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Decoder-get_best_hypothesis"></a>}}
\if{latex}{\out{\hypertarget{method-Decoder-get_best_hypothesis}{}}}
\subsection{Method \code{get_best_hypothesis()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Decoder$get_best_hypothesis(lookBack = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lookBack}}{an integer. Number of frames to look back.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a DecodeResult instance
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Decoder-get_all_final_hypothesis"></a>}}
\if{latex}{\out{\hypertarget{method-Decoder-get_all_final_hypothesis}{}}}
\subsection{Method \code{get_all_final_hypothesis()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Decoder$get_all_final_hypothesis()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
list of DecodeResult instances
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Decoder-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Decoder-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Decoder$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
