% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/light_importance.R
\name{light_importance}
\alias{light_importance}
\alias{light_importance.default}
\alias{light_importance.flashlight}
\alias{light_importance.multiflashlight}
\title{Variable Importance}
\usage{
light_importance(x, ...)

\method{light_importance}{default}(x, ...)

\method{light_importance}{flashlight}(
  x,
  data = x$data,
  by = x$by,
  type = c("permutation", "shap"),
  v = NULL,
  n_max = Inf,
  seed = NULL,
  m_repetitions = 1,
  metric = x$metrics[1],
  lower_is_better = TRUE,
  use_linkinv = FALSE,
  metric_name = "metric",
  value_name = "value",
  error_name = "error",
  label_name = "label",
  variable_name = "variable",
  ...
)

\method{light_importance}{multiflashlight}(x, ...)
}
\arguments{
\item{x}{An object of class \code{flashlight} or \code{multiflashlight}.}

\item{...}{Further arguments passed to \code{light_performance}. Not used for \code{type = "shap"}.}

\item{data}{An optional \code{data.frame}. Not used for \code{type = "shap"}.}

\item{by}{An optional vector of column names used to additionally group the results.}

\item{type}{Type of importance: "permutation" (default) or "shap". "shap" is only available if a "shap" object is contained in \code{x}.}

\item{v}{Vector of variables to assess importance for. Defaults to all variables in \code{data} except "by" and "y".}

\item{n_max}{Maximum number of rows to consider. Not used for \code{type = "shap"}.}

\item{seed}{An integer random seed used to select and shuffle rows. Not used for \code{type = "shap"}.}

\item{m_repetitions}{Number of permutations. Defaults to 1. A value above 1 provides more stable estimates of variable importance and allows the calculation of standard errors measuring the uncertainty from permuting. Not used for \code{type = "shap"}.}

\item{metric}{An optional named list of length one with a metric as element. Defaults to the first metric in the flashlight. The metric needs to be a function with at least four arguments: actual, predicted, case weights w and \code{...}. Irrelevant for \code{type = "shap"}.}

\item{lower_is_better}{Logical flag indicating if lower values in the metric are better or not. If set to FALSE, the increase in metric is multiplied by -1. Not used for \code{type = "shap"}.}

\item{use_linkinv}{Should retransformation function be applied? Default is FALSE. Not uses for \code{type = "shap"}.}

\item{metric_name}{Name of the resulting column containing the name of the metric. Defaults to "metric". Irrelevant for \code{type = "shap"}.}

\item{value_name}{Column name in resulting \code{data} containing the variable importance. Defaults to "value".}

\item{error_name}{Column name in resulting \code{data} containing the standard error of permutation importance. Defaults to "error".}

\item{label_name}{Column name in resulting \code{data} containing the label of the flashlight. Defaults to "label".}

\item{variable_name}{Column name in resulting \code{data} containing the variable names. Defaults to "variable".}
}
\value{
An object of class \code{light_importance}, \code{light} (and a list) with the following elements.
\itemize{
\item \code{data} A tibble with results. Can be used to build fully customized visualizations.
\item \code{by} Same as input \code{by}.
\item \code{type} Same as input \code{type}. For information only.
\item \code{metric_name} Column name representing the name of the metric. For information only.
\item \code{value_name} Same as input \code{value_name}.
\item \code{error_name} Same as input \code{error_name}.
\item \code{label_name} Same as input \code{label_name}.
\item \code{variable_name} Same as input \code{variable_name}.
}
}
\description{
Two algorithms to calculate variable importance are available: (a) Permutation importance and (b) SHAP importance. Algorithm (a) measures importance of variable v as the drop in performance by permuting the values of v, see Fisher et al. 2018 (reference below). Algorithm (b) measures variable importance by averaging absolute SHAP values.
}
\details{
For algorithm (a), the minimum required elements in the (multi-) flashlight are "y", "predict_function", "model", "data" and "metrics". For algorithm (b), the only required element is "shap". Call \code{add_shap} once to add such object.
Note: The values of the permutation algorithm (a) are on the scale of the selected metric. For shap algorithm (b), the values are on the scale of absolute values of the predictions.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method not implemented yet.

\item \code{flashlight}: Variable importance for a flashlight.

\item \code{multiflashlight}: Variable importance for a multiflashlight.
}}

\examples{
fit <- lm(Sepal.Length ~ Petal.Length, data = iris)
fl <- flashlight(model = fit, label = "full", data = iris, y = "Sepal.Length")
light_importance(fl)
}
\references{
Fisher A., Rudin C., Dominici F. (2018). All Models are Wrong but many are Useful: Variable Importance for Black-Box, Proprietary, or Misspecified Prediction Models, using Model Class Reliance. Arxiv.
}
\seealso{
\code{\link{most_important}}, \code{\link{plot.light_importance}}.
}
