% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_generate.R
\docType{data}
\name{simulated_data}
\alias{simulated_data}
\title{A synthetic dataset with continuous and binary covariates and a binary treatment variable (\code{trt}).}
\format{
A data frame with 1000 rows and 8 variables:
\describe{
\item{X_1}{A continuous variable sampled from \code{U(0, 1)}.}
\item{Z_1}{A binary variable sampled from \code{Bernoulli(0.35)}.}
\item{Z_2}{A binary variable sampled from \code{Bernoulli(0.5)}.}
\item{Z_3}{A binary variable sampled from \code{Bernoulli(0.65)}.}
\item{Z_4}{A binary variable sampled from \code{Bernoulli(0.2)}.}
\item{Z_5}{A binary variable sampled from \code{Bernoulli(0.35)}.}
\item{trt}{A binary treatment variable sampled from \code{Bernoulli(0.5)}.}
\item{Y}{The outcome variable calculated using the formula above.}
}
}
\usage{
data(simulated_data)
}
\description{
This dataset was generated using the formula:
\eqn{Y = 2 * Z_1 + 2 * X_1 + 2 * Z_1 * trt + \cos(X_1 \cdot 2 \pi) * trt + \epsilon},
where \eqn{\epsilon \sim N(0, 0.1)}.
}
\examples{
data(simulated_data)
head(simulated_data)
}
\keyword{datasets}
