% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printReport.R
\name{printReport}
\alias{printReport}
\title{Prepare report of fitting}
\usage{
printReport(x, file = NULL, type = "csv")
}
\arguments{
\item{x}{The output of \code{\link{fitter}}}

\item{file}{A character string giving the filename (including path) where the report should be printed}

\item{type}{A character vector giving the desired type(s) of output}
}
\value{
A list with items
\item{table}{A \code{data.frame} with the same formating as the resulting csv file.}
\item{shiny}{if \code{"shiny" \%in\% type}: a shiny object}
}
\description{
Prepares a summary of the fitting as csv or shiny
}
\details{
The routine generates a simple csv file, which is the most useful output in terms of reusability. However, the shiny output is more powerful and provides an overview of the statistics and a figure for visual/manual exploration of the fits.
Irrspective of output type being \dQuote{csv} or \dQuote{shiny}, the fit-table has the following format
\describe{
\item{package}{ package name}
\item{distr}{ name of the distribution}
\item{nargs}{ number of parameters}
\item{args}{ names of parameters, comma-seperated list}
\item{estimate}{estimated values of parameters, comma-seperated list}
\item{start}{start values of parameters, comma-seperated list}
\item{constraints}{were constraints used, logical}
\item{runtime}{the runtime in milliseconds}
\item{KS}{test statistic $D$ of a two-sided, two-sample Kolmogorov-Smirnov test}
\item{pKS}{$P$-value of a two-sided, two-sample Kolmogorov-Smirnov test}
\item{SW}{test statistic of a Shapiro-Wilks test}
\item{pSW}{$P$-value of a Shapiro-Wilks test}
}
}
\examples{
# discrete empirical data
x <- rnbinom(100, 0.5, 0.2)
r <- fitter(x, dom="dis", posList=list(stats=NA))
# create only 'shiny' app
out <- printReport(r, type="shiny")
names(out)
\dontrun{ out$shiny }
out <- printReport(r, type=c("csv")) # warning as 'file' is NULL, 
str(out) # but table (data.frame) returned

}
\author{
Markus Boenn
}
