% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Triangle.R
\name{dTRI}
\alias{dTRI}
\title{Triangular Distribution bounded between [0,1]}
\usage{
dTRI(p,mode)
}
\arguments{
\item{p}{vector of probabilities}

\item{mode}{single value for mode}
}
\value{
The output of \code{dTRI} gives a list format consisting

\code{pdf}             probability density values in vector form

\code{mean}            mean of the unit bounded triangular distribution

\code{variance}        variance of the unit bounded triangular distribution
}
\description{
These functions provide the ability for generating probability density values,
cumulative probability density values and moments about zero values for the
Triangular Distribution bounded between [0,1]
}
\details{
Setting \eqn{min=0} and \eqn{max=1} \eqn{mode=c} in the triangular distribution
a unit bounded triangular distribution can be obtained. The probability density function
and cumulative density function of a unit bounded triangular distribution with random
variable P are given by

\deqn{g_{P}(p)= \frac{2p}{c} } ;            \eqn{0 \le p < c}
\deqn{g_{P}(p)= \frac{2(1-p)}{(1-c)} } ;    \eqn{c \le p \le 1}
\deqn{G_{P}(p)= \frac{p^2}{c} } ;           \eqn{0 \le p < c}
\deqn{G_{P}(p)= 1-\frac{(1-p)^2}{(1-c)} } ; \eqn{c \le p \le 1}
\deqn{0 \le mode=c \le 1}

The mean and the variance are denoted by
\deqn{E[P]= \frac{(a+b+c)}{3}= \frac{(1+c)}{3} }
\deqn{var[P]= \frac{a^2+b^2+c^2-ab-ac-bc}{18}= \frac{(1+c^2-c)}{18} }

Moments about zero is denoted as
\deqn{E[P^r]= \frac{2c^{r+2}}{c(r+2)}+\frac{2(1-c^{r+1})}{(1-c)(r+1)}+\frac{2(c^{r+2}-1)}{(1-c)(r+2)} }
\eqn{r = 1,2,3,...}

\strong{NOTE} : If input parameters are not in given domain conditions
necessary error messages will be provided to go further
}
\examples{
#plotting the random variables and probability values
col<-rainbow(4)
x<-seq(0.2,0.8,by=0.2)
plot(0,0,main="Probability density graph",xlab="Random variable",
ylab="Probability density values",xlim = c(0,1),ylim = c(0,3))
for (i in 1:4)
{
lines(seq(0,1,by=0.01),dTRI(seq(0,1,by=0.01),x[i])$pdf,col = col[i])
}

dTRI(seq(0,1,by=0.05),0.3)$pdf     #extracting the pdf values
dTRI(seq(0,1,by=0.01),0.3)$mean    #extracting the mean
dTRI(seq(0,1,by=0.01),0.3)$var     #extracting the variance

#plotting the random variables and cumulative probability values
col<-rainbow(4)
x<-seq(0.2,0.8,by=0.2)
plot(0,0,main="Cumulative density graph",xlab="Random variable",
ylab="Cumulative density values",xlim = c(0,1),ylim = c(0,1))
for (i in 1:4)
{
lines(seq(0,1,by=0.01),pTRI(seq(0,1,by=0.01),x[i]),col = col[i])
}

pTRI(seq(0,1,by=0.05),0.3)      #acquiring the cumulative probability values
mazTRI(1.4,.3)                  #acquiring the moment about zero values
mazTRI(2,.3)-mazTRI(1,.3)^2     #variance for when is mode 0.3
#only the integer value of moments is taken here because moments cannot be decimal
mazTRI(1.9,0.5)

}
\references{
Horsnell, G. (1957). Economic acceptance sampling schemes. Journal of the Royal Statistical Society,
Series A, 120:148-191.

Johnson, N. L., Kotz, S. and Balakrishnan, N. (1994) Continuous Univariate Distributions, Vol. 2,
Wiley Series in Probability and Mathematical Statistics, Wiley

Karlis, D. & Xekalaki, E., 2008. The Polygonal Distribution. In Advances in Mathematical and Statistical
Modeling. Boston: Birkhuser Boston, pp. 21-33.

Available at: \url{http://dx.doi.org/10.1007/978-0-8176-4626-4_2} .

Okagbue, H. et al., 2014. Using the Average of the Extreme Values of a Triangular Distribution for a
Transformation, and Its Approximant via the Continuous Uniform Distribution. British Journal of Mathematics
& Computer Science, 4(24), pp.3497-3507.

Available at: \url{http://www.sciencedomain.org/abstract.php?iid=699&id=6&aid=6427} .
}
\seealso{
\code{\link[triangle]{triangle}}


---------------

\code{\link[extraDistr]{Triangular}}
}
