% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Triangle.R
\name{fitTriBin}
\alias{fitTriBin}
\title{Fitting the Triangular Binomial Distributon when binomial random variable, frequency and mode
value are given}
\usage{
fitTriBin(x,obs.freq,mode,print)
}
\arguments{
\item{x}{vector of binomial random variables}

\item{obs.freq}{vector of frequencies}

\item{mode}{single value for mode}

\item{print}{logical value for print or not}
}
\value{
The output of \code{fitTriBin} gives a list format consisting

\code{bin.ran.var} binomial random variables

\code{obs.freq} corresponding observed frequencies

\code{exp.freq} corresponding expected frequencies

\code{statistic} chi-squared test statistics value

\code{df} degree of freedom

\code{p.value} prboability value by chi-squared test statistic

\code{over.dis.para} over dispersion value.
}
\description{
The function will fit the triangular binomial distribution when random variables, corresponding
frequencies and mode parameter are given. It will provide the expected frequencies, chi-squared
test statistics value, p value, degree of freedom and over dispersion value so that it can be
seen if this distribution fits the data.
}
\details{
\deqn{0 < mode=c < 1}
\deqn{x = 0,1,2,...}
\deqn{0 < mode < 1}
\deqn{obs.freq \ge 0}

\strong{NOTE} : If input parameters are not in given domain conditions
necessary error messages will be provided to go further.
}
\examples{
No.D.D=0:7      #assigning the random variables
Obs.fre.1=c(47,54,43,40,40,41,39,95)  #assigning the corresponding frequencies
modeTriBin=EstMLETriBin(No.D.D,Obs.fre.1)$mode  #assigning the extracted the mode value
#fitting when the random variable,frequencies,mode value are given.
fitTriBin(No.D.D,Obs.fre.1,modeTriBin)

fitTriBin(No.D.D,Obs.fre.1,modeTriBin,FALSE)$exp.freq  #extracting the expected frequencies

}
\references{
Horsnell, G. (1957). Economic acceptance sampling schemes. Journal of the Royal Statistical Society,
Series A, 120:148-191.

Karlis, D. & Xekalaki, E., 2008. The Polygonal Distribution. In Advances in Mathematical and Statistical
Modeling. Boston: Birkhuser Boston, pp. 21-33.

Available at: \url{http://dx.doi.org/10.1007/978-0-8176-4626-4_2} .

Okagbue, H. et al., 2014. Using the Average of the Extreme Values of a Triangular Distribution for a
Transformation, and Its Approximant via the Continuous Uniform Distribution. British Journal of Mathematics
& Computer Science, 4(24), pp.3497-3507.

Available at: \url{http://www.sciencedomain.org/abstract.php?iid=699&id=6&aid=6427} .
}
