% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mahalanobis.R
\name{mahalanobis}
\alias{mahalanobis}
\alias{mahalanobis.default}
\alias{mahalanobis.lm}
\alias{mahalanobis.default}
\alias{mahalanobis.lm}
\title{Mahalanobis Distance}
\usage{
mahalanobis(x, ...)

\method{mahalanobis}{default}(x, center, cov, inverted = FALSE, ...)

\method{mahalanobis}{lm}(x, ...)
}
\arguments{
\item{x}{a vector or matrix of data with, say, p columns. If \code{x} is
a fitted model object then the design matrix (model matrix) is used.}

\item{\dots}{passed to \code{\link[base]{solve}} for computing the inverse
of the covariance matrix (if \code{inverted} is \code{FALSE}).  Additional
arguments are ignored when \code{x} is a fitted model object.}

\item{center}{mean vector of the distribution or second data vector of
length p or recyclable to that length.  If set to \code{FALSE}, the
centering step is skipped. This argument is ignored when \code{x} is a
fitted model object.}

\item{cov}{covariance matrix (p x p) of the distribution. This argument
is ignored when \code{x} is a fitted model object.}

\item{inverted}{logical.  If \code{TRUE}, \code{cov} is supposed to contain
the \emph{inverse} of the covariance matrix.  This argument is ignored when
\code{x} is a fitted model object.}
}
\value{
a numeric vector containing the squared Mahalanobis distances
}
\description{
Returns the squared Mahalanobis distance of all rows in \code{x} and the vector
\eqn{\mu} = \code{center} with respect to \eqn{\Sigma} = \code{cov}. This is
(for vector \code{x}) defined as \deqn{D^2 = (x - \mu)' \Sigma^{-1} (x - \mu).}
The \code{fit.models} package makes the \code{mahalanobis} function generic.  The
default method calls the \code{\link[stats]{mahalanobis}} function in the
\code{stats} package.  Methods for fitted model objects return the squared
Mahalanobis distance of all the rows in the design (model) matrix.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: the default S3 method calls \code{stats::}\code{\link[stats]{mahalanobis}}

\item \code{lm}: the method for \code{lm} objects returns the squared mahalanobis distance
for each row in the design (model) matrix. These values are computed from the diagonal elements
of the hat matrix.
}}

\examples{
stack.lm <- lm(stack.loss ~ ., data = stackloss)

# Mahalanobis distance (not squared)
sqrt(mahalanobis(stack.lm))
}
\keyword{methods}
\keyword{regression}
