% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fipp.R
\name{fipp}
\alias{fipp}
\title{Moments of symmetric additive functional computed over the induced prior
partitions (static/dynamic MFMs and DPM)}
\usage{
fipp(
  lfunc,
  Kplus,
  N,
  type = c("DPM", "static", "dynamic"),
  alpha = NULL,
  gamma = NULL,
  maxK = NULL,
  log = FALSE
)
}
\arguments{
\item{lfunc}{a logged version of the additive symmetric functional intended
to compute over the prior partition. The function should only accept one
argument N_j (= number of observations in each partition).}

\item{Kplus}{a numeric value that represents the number of filled clusters in
data}

\item{N}{the number of observation in data}

\item{type}{the type of model considered. Three models (static/dynamic MFMs
and DPM) are supported.}

\item{alpha, gamma}{hyperparameters for the Dirichlet prior. For static MFM,
gamma should be specified, while alpha should be specified for all other
models (that is, for dynamic MFM and DPM).}

\item{maxK}{the maximum number of K (= the number of mixture components)
considered. Only needed for static/dynamic MFMs.}

\item{log}{logical, indicating whether the probability should be logged or
not}
}
\value{
\code{fipp} returns a function which takes two required arguments
(required only for static/dynamic MFMs) and 2 optional arguments:

\describe{ \item{priorK}{a function with support on the positive integers.
The function serves as a prior of K (default = NULL which is for DPM).}
\item{priorKparams}{a named list of prior parameters for the function
supplied in argument \code{priorK} (default = NULL which is for
DPM).}\item{order}{maximum number of moments to be evaluated by the
function (default = 2)}\item{replace2ndwvar}{replace 2nd moment with
variance (default = TRUE)}}
}
\description{
\code{fipp} is a closure which returns a function that computes moments of a
user-specified functional over the induced prior partitions. Required
arguments are: prior distribution of the number of mixture components and its
parameters (see examples for details). Optional arguments are: the number of
moments to be evaluated (currently only up to 2 are implemented) and whether
the mean/variance or 1st/2nd moments should be printed out as a result of
computing the first two moments (default is set to print out mean/variance).
}
\examples{
## Determine mean/variance of the number of singleton clusters for dynamic 
## MFM model conditional on K+ = 5, alpha = 1 with a sample size N = 100.
## We assume that K will be smaller than 30 by setting maxK = 30, please
## increase this value for more realistic analysis.
## 
## First create the function singletons():
singletons <- fipp(lfunc = function(n) log(n==1), Kplus = 5, N = 100,
  type = "dynamic", alpha = 1, maxK = 30)

## Then evaluate it using a Geom(0.1) prior:
singletons(dgeom, list(prob = 0.1))

## Try a different prior, the Poisson prior Pois(1):
singletons(dpois, list(lambda = 1))

## If mean is the only thing you are interested in, try the following:
singletons(dpois, list(lambda = 1), order = 1)

## Also, if you want 1st/2nd moments instead of mean/variance, try:
singletons(dpois, list(lambda = 1), replace2ndwvar = FALSE)

}
\references{
Greve, J., Grün, B., Malsiner-Walli, G., and Frühwirth-Schnatter, S. (2020)
Spying on the Prior of the Number of Data Clusters and the Partition Distribution in Bayesian Cluster Analysis.
\url{https://arxiv.org/abs/2012.12337}

Escobar, M. D., and West, M. (1995) Bayesian Density Estimation and Inference Using Mixtures.
\emph{Journal of the American Statistical Association} \bold{90} (430), Taylor & Francis: 577-–88.
\url{https://www.tandfonline.com/doi/abs/10.1080/01621459.1995.10476550}

Miller, J. W., and Harrison, M. T. (2018) Mixture Models with a Prior on the Number of Components.
\emph{Journal of the American Statistical Association} \bold{113} (521), Taylor & Francis: 340-–56.
\url{https://www.tandfonline.com/doi/full/10.1080/01621459.2016.1255636}

Frühwirth-Schnatter, S., Malsiner-Walli, G., and Grün, B. (2020)
Generalized mixtures of finite mixtures and telescoping sampling \url{https://arxiv.org/abs/2005.09918}
}
