% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_data_exploration.R
\name{fst_get_top_words}
\alias{fst_get_top_words}
\title{Make Top Words Table}
\usage{
fst_get_top_words(
  data,
  number = 10,
  norm = "number_words",
  pos_filter = NULL,
  strict = TRUE
)
}
\arguments{
\item{data}{A dataframe of text in CoNLL-U format.}

\item{number}{The number of top words to return, default is `10`.}

\item{norm}{The method for normalising the data. Valid settings are
`"number_words"` (the number of words in the responses, default),
`"number_resp"` (the number of responses), or `NULL` (raw count returned).}

\item{pos_filter}{List of UPOS tags for inclusion, default is `NULL` which
means all word types included.}

\item{strict}{Whether to strictly cut-off at `number` (ties are
alphabetically ordered), default is `TRUE`.}
}
\value{
A table of the most frequently occurring words in the data.
}
\description{
Creates a table of the most frequently-occurring words (unigrams) within the
data.
}
\examples{
fst_get_top_words(conllu_dev_q11_1_nltk, number = 15, strict = FALSE)
cb <- conllu_cb_bullying
pf <- c("NOUN", "VERB", "ADJ", "ADV")
fst_get_top_words(cb, number = 5, norm = "number_resp", pos_filter = pf)
}
