% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{planned_day_ahead_transmission_capacity_SE3_to_FI}
\alias{planned_day_ahead_transmission_capacity_SE3_to_FI}
\title{Planned day-ahead transmission capacity SE3-FI}
\usage{
planned_day_ahead_transmission_capacity_SE3_to_FI(
  start_time = NA,
  end_time = NA,
  user_key = NA
)
}
\arguments{
\item{start_time}{Start time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{end_time}{End time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/open-data-forms/registration/}
}
\value{
A data frame object that contains planned day-ahead transmission
capacity from Central-Sweden (SE3) to Finland (FI). Transmission
capacity is given hourly for every next week hour.
}
\description{
Check https://data.fingrid.fi/en/dataset/planned-day-ahead-transmission-capacity-se3-fi
}
\examples{
\dontrun{
library(finnishgrid)
start = "2021-01-01T00:00:00+0200"  # UTC+2 offset, Helsinki time
end = "2021-01-10T00:00:00+0200"    # UTC+2 offset, Helsinki time
key = "MY_SUPER_SECRET"
df <- planned_day_ahead_transmission_capacity_SE3_to_FI(
    start_time = start,
    end_time = end,
    user_key = key)
summary(df)
}
}
