% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicators.R
\name{indicator_order}
\alias{indicator_order}
\title{Indicator order number}
\usage{
indicator_order(DomainID, AreaTypeID, ParentAreaTypeID, path)
}
\arguments{
\item{DomainID}{Numeric vector, id of domains of interest}

\item{AreaTypeID}{Numeric vector, the Fingertips ID for the area type. This
argument accepts "All", which returns data for all available area types for
the indicator(s), though this can take a long time to run}

\item{ParentAreaTypeID}{Numeric vector, the comparator area type for the data
extracted; if NULL the function will use the first record for the specified
`AreaTypeID` from the area_types() function}

\item{path}{String; Fingertips API address. Function will default to the
correct address}
}
\value{
A data frame of indicator ids and sequence number
}
\description{
Outputs a tibble of indicator ids and their sequence number for the provided
domain and area type. This enables the user to order the indicators as they
are ordered on the Fingertips website.
}
\examples{
\dontrun{
indicator_order(DomainID = 1938133161, AreaTypeID = 102, ParentAreaTypeID = 6)}
}
\seealso{
\code{\link{indicators}} for indicators and their parent domains and profiles,
  \code{\link{area_types}} for area type and their parent mappings,
  \code{\link{indicator_metadata}} for indicator metadata,
  \code{\link{profiles}} for profile lookups,
  \code{\link{deprivation_decile}} for deprivation decile lookups,
  \code{\link{category_types}} for category lookups,
  \code{\link{indicator_areatypes}} for indicators by area types lookups and
  \code{\link{nearest_neighbours}} for a vector of nearest neighbours for an area

Other lookup functions: 
\code{\link{area_types}()},
\code{\link{category_types}()},
\code{\link{deprivation_decile}()},
\code{\link{indicator_areatypes}()},
\code{\link{indicator_metadata}()},
\code{\link{indicators_unique}()},
\code{\link{indicators}()},
\code{\link{nearest_neighbours}()},
\code{\link{profiles}()}
}
\concept{lookup functions}
