% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findInGit.R
\name{findInGit}
\alias{findInGit}
\title{Find pattern in files of a 'git' repository}
\usage{
findInGit(
  ext,
  pattern,
  wholeWord = FALSE,
  ignoreCase = FALSE,
  perl = FALSE,
  excludePattern = NULL,
  excludeFoldersPattern = NULL,
  root = ".",
  output = "viewer"
)
}
\arguments{
\item{ext}{file extension, e.g. \code{"R"} or \code{"js"}}

\item{pattern}{pattern to search for, a regular expression, e.g.
\code{"function"} or \code{"^function"}}

\item{wholeWord}{logical, whether to match the whole pattern}

\item{ignoreCase}{logical, whether to ignore the case}

\item{perl}{logical, whether \code{pattern} is a Perl regular expression}

\item{excludePattern}{a pattern; exclude from search the files and folders
which match this pattern}

\item{excludeFoldersPattern}{a pattern; exclude from search the folders
which match this pattern}

\item{root}{path to the root directory to search from}

\item{output}{one of \code{"viewer"}, \code{"dataframe"} or
\code{"viewer+dataframe"}; see examples}
}
\value{
A dataframe if \code{output="dataframe"}, otherwise a
  \code{htmlwidget} object.
}
\description{
Find a pattern in the files with a given extension, in all
  branches of a 'git' repository.
}
\examples{
library(findInGit)
library(R.utils) # to use the `copyDirectory` function
folder1 <- system.file("htmlwidgets", package = "findInGit")
folder2 <- system.file("htmlwidgets", "lib", package = "findInGit")
tmpDir <- paste0(tempdir(), "_gitrepo")
dir.create(tmpDir)
# set tmpDir as the working directory
cd <- setwd(tmpDir)
# copy folder1 in tmpDir
copyDirectory(folder1, recursive = FALSE)
# initialize git repo
system("git init")
# add all files to git
system("git add -A")
# commit files
system('git commit -m "mycommit1"')
# create a new branch
system("git checkout -b newbranch")
# copy folder2 in tmpDir, under the new branch
copyDirectory(folder2, recursive = FALSE)
# add all files to git
system("git add -A")
# commit files
system('git commit -m "mycommit2"')

# now we can try `findInGit`
\donttest{findInGit(ext = "js", pattern = "ansi")}

# get results in a dataframe:
\donttest{findInGit(ext = "js", pattern = "ansi", output = "dataframe")}

# one can also get the widget and the dataframe:
fig <- findInGit(ext = "css", pattern = "color", output = "viewer+dataframe")
fig
FIG2dataframe(fig)

# return to initial current directory
setwd(cd)
# delete tmpDir
unlink(tmpDir, recursive = TRUE, force = TRUE)
}
