% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{variables}
\alias{variables}
\title{FinBIF record variables}
\description{
FinBIF record variables that can be selected in a finbif occurrence search.
}
\section{Identifiers}{

All identifiers are returned in the form of a URI. Identifiers include:
\itemize{
\item \code{record_id} Character.
The ID of a record of organism's occurrence at a time and place.
\item \code{individual_id} Character.
ID of an individual organism (e.g., a ringed bird that has been captured
multiple times will have a single \code{individual_id} and multiple \code{record_id}s
corresponding to each capture).
\item \code{event_id} Character.
Event ID. An event can contain one or more records (e.g., a survey of
plants at a particular location and time.)
\item \code{document_id} Character.
Document ID. A set of events that share common metadata.
\item \code{form_id} Character.
Form ID. The form used to create the document, event, record data.
\item \code{collection_id} Character.
Collection ID. All documents, events, and records belong to a collection
(e.g., a museum collection, or the datasets collected by a specific
institution). Collections themselves can be part of a larger
(super)collection (e.g., all the collections at a specific museum). Only
the lowest level collection ID for a record is returned. Use
\code{finbif_collections()} to explore the hierarchy of collections.
\item \code{source_id} Character.
Source ID. The source of the collection's data.
}
}

\section{Taxa}{

Variables related to taxonomy of records include:
\itemize{
\item \code{taxon_id} Character.
The taxon ID in the form of a URI.
\item \code{orig_taxon_id} Character.
The taxon ID before (if any) annotation.
\item \code{annotated_taxon_id} Character.
The new taxon ID if the record has had it's taxonomy annotated.
\item \code{reported_taxon_id} Character.
The taxon ID as originally reported by the record creator.
\item \code{scientific_name} Character.
Scientific name of taxon.
\item \code{orig_scientific_name} Character.
The scientific name before (if any) annotation.
\item \code{scientific_display_name} Character.
Scientific name of taxon formatted for display (e.g., taxa with genus only
will be formatted as \emph{Genus sp.}).
\item \code{orig_scientific_display_name} Character.
Scientific display name before (if any) annotation.
\item \code{common_name} Character.
Common (vernacular) name of taxon.
\item \code{orig_common_name} Character.
Common name before (if any) annotation.
\item \code{reported_name} Character.
The name of the taxon as originally reported by the record creator.
\item \code{scientific_name_italicised} Logical.
Is the scientific name normally italicised (i.e., is the taxonomic rank
genus or below.)
\item \code{orig_scientific_name_italicised} Logical.
Is the original scientific name normally italicised.
\item \code{scientific_name_author} Character.
The authority for the taxon scientific name.
\item \code{orig_scientific_name_author} Character.
The authority for the taxon scientific name before (if any) annotation.
\item \code{reported_author} Character.
The authority of the taxon as originally reported by the record creator.
\item \code{taxon_rank} Character.
The taxonomic rank of the taxon (in the form of a URI).
\item \code{orig_taxon_rank} Character.
The taxonomic rank of the taxon (in the form of a URI) before (if any)
annotation.
\item \code{informal_groups} List.
The informal taxonomic groups that the taxon belongs to (e.g., birds) in
the form of URIs.
\item \code{orig_informal_groups} List.
The informal taxonomic groups that the taxon belonged to before (if any)
annotation.
\item \code{reported_informal_groups} List.
The informal taxonomic groups that the taxon belongs to as reported by the
record creator.
\item \code{taxon_checklist} Character.
The checklist (as a URI) that that taxon is found in.
\item \code{orig_taxon_checklist} Character.
The checklist (as a URI) that that taxon was found in before (if any)
annotation.
\item \code{taxon_finnish} Logical.
Is the taxon considered Finnish. The definition of a Finnish taxon differs
by taxonomic group?
\item \code{orig_taxon_finnish} Logical.
Was the taxon considered Finnish before (if any) annotation?
\item \code{is_unidentifiable} Logical.
Is the record unable to be identified?
}
}

\section{Abundance, sex & life history}{

Variables related to abundance, sex and life history include:
\itemize{
\item \code{abundance} Integer.
Number of individuals recorded or inferred from the record. Note that many
records with \code{abundance = 1} only indicate the record is of one individual
and may not necessarily imply that this was the abundance at that specified
place and time (e.g., a preserved museum specimen consisting of a single
individual).
\item \verb{\{female|male\}_abundance} Integer.
Number of female or male individuals recorded.
\item \code{pair_abundance} Integer.
Number of mating pairs recorded.
\item \code{abundance_verbatim} Character.
The abundance as reported by the record creator.
\item \code{life_stage} Character.
Life stage of individual(s) recorded.
\item \code{sex} Character.
Sex of individual(s) recorded.
}
}

\section{Location}{

Variables related to the location of records include:
\itemize{
\item \verb{\{lat|lon\}_wgs84} Numeric.
Coordinates (in \href{https://spatialreference.org/ref/epsg/wgs-84/}{WGS84}
coordinate system) of the central point of a bounding box encompassing the
record's geographic coverage.
\item \verb{\{lat|lon\}_\{min|max\}_\{euref|kkj|wgs84\}}. Numeric.
Vertices of a bounding box encompassing the record's geographic coverage.
Coordinates are available in
\href{https://spatialreference.org/ref/epsg/etrs89-etrs-tm35fin/}{EUREF},
\href{https://spatialreference.org/ref/epsg/2393/}{KKJ}, or
\href{https://spatialreference.org/ref/epsg/wgs-84/}{WGS84}.
\item \code{coordinates_uncertainty} Integer.
The horizontal distance (in meters) from the record's given coordinates
describing the smallest circle containing the whole of the record's
location.
\item \code{coordinates_source}
\item \verb{footprint_\{euref|kkj|wgs84\}} Character.
Well-Known Text (WKT) representation of the geographic shape defining the
location of the record in either EUREF, KKJ or WGS84 coordinate systems.
\item \code{country} Character.
The country of the record's location.
\item \code{province} Character.
The administrative area directly below the level of country. For data from
Finland FinBIF uses the concept of
\href{https://laji.fi/en/theme/emk}{Biogeographical Province}. See link for
details.
\item \code{municipality}. Character.
Administrative level below province.
\item \code{higher_geography} Character.
Geographic place name that is at higher level than country.
\item \code{line_length_m} Integer.
The length of linear locations (e.g., line transect surveys).
\item \code{area_m2} Integer.
The size of record's location in meters squared.
\item \code{is_breeding_location} Logical.
Whether or not the occurrence is recorded at a known breeding location.
}
}

\section{Time}{

Variables related to time of record include:
\itemize{
\item \code{date_start} Character.
The date the recording event began.
\item \code{date_end} Character.
The date the recording event ended.
\item \code{hour_start} Integer.
The hour (24 hour time) of the day the recording event began.
\item \code{hour_end} Integer.
The hour (24 hour time) of the day the recording event ended.
\item \code{minute_start} Integer.
The minute of the hour the recording event began.
\item \code{minute_end} Integer.
The minute of the hour the recording event started.
\item \code{ordinal_day_start} Integer.
The ordinal day of the year the recording event began.
\item \code{ordinal_day_end} Integer.
The ordinal day of the year the recording event ended
\item \code{season_start} Integer.
The day of the year the recording event began. A four digit number
indicating the day of the year in MMDD (\%m\%d) format.
\item \code{season_end} Integer.
The day of the year the recording event ended. A four digit number
indicating the day of the year in MMDD (\%m\%d) format.
\item \code{century} Integer.
The century during which the recording event occurred (\code{NA} if the event
spans multiple centuries).
\item \code{decade} Integer.
The decade during which the  recording event occurred (\code{NA} if the event
spans multiple decades).
\item \code{year} Integer.
The year during which the recording event occurred (\code{NA} if the event spans
multiple years).
\item \code{month} Integer.
The month of the year during which the recording event occurred (\code{NA} if
the event spans multiple months).
\item \code{day} Integer.
The day of the month during which the recording event occurred (\code{NA} if the
event spans multiple days).
\item \code{formatted_date_time} Character.
Date and time of the recording event formatted for display.
\item \code{date_created} Character.
The date the original data was created.
\item \code{first_load_date} Character.
The date the record was first loaded into the FinBIF database.
\item \code{modified_date} Character.
The most recent date the original data was modified.
\item \code{load_date} Character.
The most recent date the record was loaded into the FinBIF database.
}
}

\section{Data restrictions}{

Variables related to restricted records include:
\itemize{
\item \code{restriction} Logical.
Has the record been restricted in some way (e.g., geospatially aggregated).
\item \code{restriction_level} Character.
What level of restriction has been applied to the record.
\item \code{restriction_reasons} List.
List of reasons restriction has been applied.
\item \code{restriction_reasons_conservation} Logical.
Has the record been restricted for reasons of conservation.
\item \code{restriction_reasons_embargo} Logical.
Has the record been restricted due to a temporary data embargo.
\item \code{restriction_reasons_custom} Logical.
Has the record been restricted for other reasons.
}
}

\section{Data quality}{

Variables related to the quality of records include:
\itemize{
\item \code{any_issues} Logical.
Are there any data quality issues associated with the record it's event or
document.
\item \code{record_reliable} Logical.
The \code{"collection_reliability"} is 4-5 or the record has been "confirmed"
and has no quality issues (record, event or document).
\item \code{collection_reliability} Integer.
A numeric rating of reliability from 1 (low reliability) to 5 (high
reliability) for the collection the record comes from.
\item \code{taxon_reliability} Character.
Reliability of the record taxonomic identification.
\item \code{taxon_reliability_message}
Remarks associated with \code{taxon_reliability}.
\item \code{taxon_reliability_source}
Source of the \code{taxon_reliability} rating.
\item \code{reported_taxon_confidence}
Reliability of the record taxonomic identification as reported by the
original data author.
\item \verb{\{document|time|location|event|record\}_issue} Character.
Issues with record associated with its document, time, location, event, or
the record itself.
\item \verb{\{document|time|location|event|record\}_issue_message} Character.
Details about the issue.
\item \verb{\{document|time|location|event|record\}_issue_source}
Source determining the issue.
}
}

\section{Misc}{

Other variables:
\itemize{
\item \code{observers_ids} List.
List of observer identifiers for the record.
\item \code{determiner} Character.
Person who determined the taxonomic identification of the record.
\item \code{record_basis} Character.
The type of or method used to obtain the record.
\item \code{superrecord_basis} Character.
Higher level type of or method used to obtain the record.
\item \code{type_specimen} Logical.
Whether or not the record is of a type specimen.
\item \code{is_wild} Logical.
Whether or not the record is of a "wild" organism.
\item \code{license} Character.
The license of the data associated with the record.
\item \verb{\{document|event|record\}_notes} Character.
Notes associated with the document, event or record itself.
\item \verb{\{document|record\}_keywords} List.
List of keywords associated with the document or record.
\item \code{record_annotation_count} Integer.
How many annotations are associated with the record.
\item \code{sample_count} Integer.
How many material samples (DNA extractions, etc., ...) are associated with
the record.
\item \verb{\{document|event|record\}_media_count} Integer.
How many media items (images, audio, video, etc., ...) are associated with
the record's document, event or the record itself.
}
}

