% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finalfit_internal_functions.R
\name{extract_fit}
\alias{extract_fit}
\alias{extract_fit.glm}
\alias{extract_fit.glmerMod}
\alias{extract_fit.lm}
\alias{extract_fit.lmerMod}
\alias{extract_fit.coxph}
\alias{extract_fit.crr}
\alias{extract_fit.stanfit}
\title{Extract model output to dataframe}
\usage{
extract_fit(...)

\method{extract_fit}{glm}(.data, explanatory_name = "explanatory",
  estimate_name = "OR", estimate_suffix = "", p_name = "p",
  exp = TRUE, confint_type = "profile", confint_level = 0.95, ...)

\method{extract_fit}{glmerMod}(.data, explanatory_name = "explanatory",
  estimate_name = "OR", estimate_suffix = "", p_name = "p",
  confint_type = "Wald", confint_level = 0.95, ...)

\method{extract_fit}{lm}(.data, explanatory_name = "explanatory",
  estimate_name = "Coefficient", estimate_suffix = "", p_name = "p",
  confint_level = 0.95, ...)

\method{extract_fit}{lmerMod}(.data, explanatory_name = "explanatory",
  estimate_name = "OR", estimate_suffix = "", p_name = "p",
  confint_type = "Wald", confint_level = 0.95, ...)

\method{extract_fit}{coxph}(.data, explanatory_name = "explanatory",
  estimate_name = "HR", estimate_suffix = "", p_name = "p", ...)

\method{extract_fit}{crr}(.data, explanatory_name = "explanatory",
  estimate_name = "HR", estimate_suffix = "", p_name = "p", ...)

\method{extract_fit}{stanfit}(.data, explanatory_name = "explanatory",
  estimate_name = "OR", estimate_suffix = "", p_name = "p",
  digits = c(2, 2, 3), X, ...)
}
\arguments{
\item{...}{Other arguments.}

\item{.data}{Model output.}

\item{explanatory_name}{Name for this column in output.}

\item{estimate_name}{Name for this column in output.}

\item{estimate_suffix}{Appeneded to estimate name.}

\item{p_name}{Name given to p-value estimate}

\item{confint_type}{One of \code{c("profile", "default")} for GLM
models or \code{c("profile", "Wald", "boot")} for \code{glmer/lmer} models.
Not implemented for \code{lm, coxph or coxphlist}.}

\item{confint_level}{The confidence level required.}

\item{X}{Design matrix from Stan modelling procedure.}
}
\description{
Internal function, not usually called directly.

Internal function, not called directly.

Internal function, not called directly.

extract_fit.coxme = function(.data, explanatory_name="explanatory", estimate_name="HR",
																estimate_suffix = "",  p_name = "p",
																confint_level = 0.95, ...){
	x=.data
	if(confint_type == "default") confint_type = "Wald"
	explanatory = names(coxme::fixef(x))
	estimate = exp(coxme::fixef(x))
	# confint = 
	# p =
	L_confint_name = paste0("L", confint_level*100)
	U_confint_name = paste0("U", confint_level*100)
	
	df.out = dplyr::tibble(explanatory, estimate, confint[,1], confint[,2], p)
	colnames(df.out) = c(explanatory_name, paste0(estimate_name, estimate_suffix),
											 L_confint_name, U_confint_name, p_name)
	
	if(confint_level != 0.95){
		df.out = df.out %>% dplyr::select(-p_name)
	}
	df.out = data.frame(df.out)
	return(df.out)
}
Extract model output to dataframe
}
\keyword{internal}
