% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_any_jsats.R
\name{read_jsats}
\alias{read_jsats}
\title{Read an Acoustic Receiver File}
\usage{
read_jsats(path, file, timezone = "America/Los_Angeles")
}
\arguments{
\item{path}{the path to the folder containing the desired file}

\item{file}{the path of the desired file}

\item{timezone}{the Olsen Named time zone, default is "America/Los_Angeles"}
}
\value{
A dataframe converting the raw detection data into rows of detections
}
\description{
This function takes a raw acoustic detection file generated by a Lotek,
Teknologic, or ATS JSATS receiver and determines which reader function to use
to process it into a dataframe which can be used by the filtering functions
in this package.
}
\examples{
# Read in any ATS, LOTEK, TEKNO file

# list of files
path = system.file("extdata", package = "filteRjsats")
files <- list.files(path)

# Read the files
raw_data <- list()
for(i in 1:length(files)){
raw_data[[i]] <- read_jsats(path = path, file = files[i],
timezone = "America/Los_Angeles")
}
# Warnings are expected due to the formatting of ATS files
}
