% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fig.R
\name{fig_scale}
\alias{fig_scale}
\title{Scales the Dimensions of Multiple Figs}
\usage{
fig_scale(..., border_colour = "transparent")
}
\arguments{
\item{...}{Multiple figs created with \code{fig()}.}

\item{border_colour}{Colour of the border to be added around the smaller figs.}
}
\value{
A list of figs which have been resized, which can be input directly
into \code{fig_wrap()} or \code{patchwork::wrap_plots()}.
}
\description{
Finds the dimensions of the largest figs, and adds a border of the given
colour around the other figs, to ensure they are all of the same dimensions
and scale properly when displayed on in a patchwork together.
}
\examples{
library(figpatch)
fl <- image_path <- system.file("extdata",
  package = "figpatch",
  mustWork = TRUE
) \%>\%
  list.files(
    pattern = "png",
    full.names = TRUE
  )

# without scaling
fl \%>\%
  lapply(fig) \%>\%
  fig_wrap(ncol = 2)

# with scaling
fl \%>\%
  lapply(fig) \%>\%
  fig_scale() \%>\%
  fig_wrap(ncol = 2)
}
