% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fhir_body.R
\docType{methods}
\name{fhir_body}
\alias{fhir_body}
\alias{fhir_body,list,missing-method}
\alias{fhir_body,list,missing-methods}
\alias{fhir_body,list,character-method}
\alias{fhir_body,list,character-methods}
\alias{fhir_body,character,character-method}
\alias{fhir_body,character,character-methods}
\title{Create \linkS4class{fhir_body} object}
\usage{
fhir_body(content, type)

\S4method{fhir_body}{list,missing}(content)

\S4method{fhir_body}{list,character}(content, type)

\S4method{fhir_body}{character,character}(content, type)
}
\arguments{
\item{content}{A character vector of length one representing the body for the post in the format specified in \code{type}.
If you provide a named list here, it will be taken as key value pairs of FHIR search parameters
and will be concatenated appropriately. In this case the \code{type} will automatically be set to
\code{"application/x-www-form-urlencoded"}. See examples.}

\item{type}{A string defining the type of the body e.g. \code{"application/x-www-form-urlencoded"} or \code{"xml"}.}
}
\value{
An object of type \linkS4class{fhir_body}.
}
\description{
Create \linkS4class{fhir_body} object
}
\examples{
#body that could be used in a FHIR search request POSTed to an URL like baseurl/Patient/_search
fhir_body(content = "gender=female&_summary=count", type="application/x-www-form-urlencoded")
fhir_body(content = list("gender" = "female", "_summary" = "count"))
}
