% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/from_var_to_var.R
\name{from_var_to_var}
\alias{from_var_to_var}
\alias{rowcol_to_index}
\alias{index_to_rowcol}
\alias{gxgy_to_index}
\alias{gxgy_to_lxly}
\alias{gxgy_to_qxqy}
\alias{gxgy_to_rowcol}
\alias{gxgy_to_hectindex}
\alias{index_to_gxgy}
\title{Functions to get variables from other variables.}
\usage{
rowcol_to_index(rowno, colno, gridsize, plotdim)

index_to_rowcol(index, gridsize, plotdim)

gxgy_to_index(gx, gy, gridsize, plotdim)

gxgy_to_lxly(gx, gy, gridsize, plotdim)

gxgy_to_qxqy(gx, gy, gridsize, plotdim)

gxgy_to_rowcol(gx, gy, gridsize, plotdim)

gxgy_to_hectindex(gx, gy, plotdim)

index_to_gxgy(index, gridsize, plotdim)
}
\arguments{
\item{rowno, colno}{Row and column number -- as defined in a census plot.}

\item{gridsize}{The gridsize of the census plot (commonly 20 m).}

\item{plotdim}{The global dimensions of the census plot (i.e. the
maximum possible values of \code{gx} and \code{gy}).}

\item{index}{Index number as defined for a census plot.}

\item{gx, gy}{A number; global x and y position in a census plot.}
}
\value{
A vector or dataframe (see examples).
}
\description{
These functions wrap their corresponding functions from the CTFS R Package,
but these versions are stricter. The main differences are these:
\itemize{
\item names use "_" not ".".
\item argument gridsize defaults to missing to force the user to provide it.
\item If the argument \code{plotdim} is missing from functions \code{gxgy_fun()}, its value
will be guessed and notified.
}
}
\details{
\code{gxgy_to_qxqy()} didn't exist in the original CTFS R Package. Added for
consistency.
}
\examples{
gxgy_to_index(c(0, 400, 990), c(0, 200, 490), gridsize = 20)

gridsize <- 20
plotdim <- c(1000, 500)

x <- gxgy_to_hectindex(1:3, 1:3, plotdim)
x
typeof(x)
is.data.frame(x)
is.vector(x)

x <- gxgy_to_index(1:3, 1:3, gridsize, plotdim)
x
typeof(x)
is.data.frame(x)
is.vector(x)

x <- gxgy_to_lxly(1:3, 1:3, gridsize, plotdim)
x
typeof(x)
is.data.frame(x)
is.vector(x)

x <- gxgy_to_rowcol(1:3, 1:3, gridsize, plotdim)
x
typeof(x)
is.data.frame(x)
is.vector(x)

x <- index_to_rowcol(1:3, gridsize, plotdim)
x
typeof(x)
is.data.frame(x)
is.vector(x)

x <- rowcol_to_index(1:3, 1:3, gridsize, plotdim)
x
typeof(x)
is.data.frame(x)
is.vector(x)

index_to_gxgy(1:3, gridsize, plotdim)
}
\author{
Rick Condit, Suzanne Lao.
}
\keyword{internal}
