% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_subquad.R
\name{add_subquad}
\alias{add_subquad}
\title{Add column \code{subquadrat} based on \code{QX} and \code{QY} coordinates.}
\usage{
add_subquad(data, x_q, y_q = x_q, x_sq, y_sq = x_sq, subquad_offset = NULL)
}
\arguments{
\item{data}{A dataframe with quadrat coordinates \code{QX} and \code{QY} (e.g. a
\emph{ViewFullTable}).}

\item{x_q, y_q}{Size in meters of a quadrat's side. For ForestGEO sites, a
common value is 20.}

\item{x_sq, y_sq}{Size in meters of a subquadrat's side. For ForestGEO sites,
a common value is 5.}

\item{subquad_offset}{Either \code{-1} or \code{1}, to rest or add one unit to the
digit of each subquadrat that represents the column number.

\if{html}{\out{<div class="sourceCode R">}}\preformatted{First column is 0    First column is 1
-----------------    -----------------
   04 14 24 34          14 24 34 44
   03 13 23 33          13 23 33 43
   02 12 22 32          12 22 32 42
   01 11 21 31          11 21 31 41
}\if{html}{\out{</div>}}}
}
\value{
Returns \code{data} with the additional variable \code{subquadrat}.
}
\description{
Add column \code{subquadrat} based on \code{QX} and \code{QY} coordinates.
}
\examples{
# styler: off
vft <- tribble(
   ~QX,  ~QY,
  17.9,    0,
   4.1,   15,
   6.1, 17.3,
   3.8,  5.9,
   4.5, 12.4,
   4.9,  9.3,
   9.8,  3.2,
  18.6,  1.1,
  17.3,  4.1,
   1.5, 16.3
)
# styler: on

add_subquad(vft, 20, 20, 5, 5)

add_subquad(vft, 20, 20, 5, 5, subquad_offset = -1)

}
\seealso{
Other functions to add columns to dataframes: 
\code{\link{add_status_tree}()},
\code{\link{add_var}()}

Other functions for ForestGEO data: 
\code{\link{add_status_tree}()},
\code{\link{add_var}()}

Other functions for fgeo vft: 
\code{\link{add_status_tree}()},
\code{\link{add_var}()},
\code{\link{guess_plotdim}()},
\code{\link{pick_drop}}
}
\author{
Anudeep Singh and Mauro Lepore.
}
\concept{functions for ForestGEO data}
\concept{functions for fgeo vft}
\concept{functions to add columns to dataframes}
