% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fgeo.R
\name{type_vft}
\alias{type_vft}
\alias{type_taxa}
\title{Help to read ForestGEO data safely, with consistent columns type.}
\usage{
type_vft()

type_taxa()
}
\value{
A list.
}
\description{
A common cause of problems is feeding functions with data which columns are
not all of the expected type. The problem often begins when reading data from
a text file with functions such as \code{\link[utils:read.table]{utils::read.csv()}},
\code{\link[utils:read.table]{utils::read.delim()}}, and friends -- which commonly guess wrongly the column
type that you more likely expect. These common offenders are strongly
discouraged; instead consider using \code{readr::read_csv()}, \code{readr::read_tsv()},
and friends, which guess column types correctly much more often than their
analogs from the \strong{utils} package.

\code{type_vft()} and \code{type_taxa()} help you to read data more safely by
explicitly specifying what type to expect from each column of known datasets.
These functions output the specification of column types used internally by
\code{\link[=read_vft]{read_vft()}} and \code{\link[=read_taxa]{read_taxa()}}:
\itemize{
\item \verb{type_vft():} Type specification for \emph{ViewFullTable}.
\item \verb{type_taxa():} Type specification for \emph{ViewFullTaxonomy}.
}
}
\details{
Types reference (for more details see \code{\link[=read_delim]{read_delim()}}):
\itemize{
\item c = character,
\item i = integer,
\item n = number,
\item d = double,
\item l = logical,
\item D = date,
\item T = date time,
\item t = time,
\item ? = guess,
\item or _/- to skip the column.'.
}
}
\examples{
assert_is_installed("fgeo.x")
library(fgeo.x)
library(readr)

str(type_vft())

read_csv(example_path("view/vft_4quad.csv"), col_types = type_vft())

str(type_taxa())

read_csv(example_path("view/taxa.csv"), col_types = type_taxa())
}
\seealso{
\code{\link[readr:read_delim]{readr::read_delim()}}.

Other functions to operate on column types: 
\code{\link{type_ensure}()}

Other functions to read text files delivered by ForestgGEO's database: 
\code{\link{read_vft}()}
}
\concept{functions to import/export ForestGEO data}
\concept{functions to operate on column types}
\concept{functions to read text files delivered by ForestgGEO's database}
\keyword{internal}
