% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suffix_match.R
\name{suffix_match}
\alias{suffix_match}
\title{Suffix a strings where a vector exactly matches one specific string.}
\usage{
suffix_match(string, to_match, .match, suffix)
}
\arguments{
\item{string}{A vector of strings to suffix.}

\item{to_match}{A vector of strings to match with \code{.match}.}

\item{.match}{A string to match the vector \code{to_match} with.}

\item{suffix}{A suffix to add at the end of each element of \code{string}.}
}
\value{
A modified version of \code{x}.
}
\description{
Suffix a strings where a vector exactly matches one specific string.
}
\examples{
suffix_match(
  string = c("one", "banana"),
  to_match = c("number", "fruit"),
  .match = "number",
  suffix = "_num"
)

suffix_match(
  string = c("tag1", "tag2"),
  to_match = c("dead", "not-dead"),
  .match = "dead",
  suffix = ".d"
)

vft <- data.frame(
  Tag = c("01", "02"),
  Status = c("dead", "alive"),
  stringsAsFactors = FALSE
)
transform(vft, tagged = suffix_match(Tag, Status, "dead", ".d"))
}
\concept{functions for internal use in other fgeo packages}
\concept{general functions to edit data in place}
\keyword{internal}
