% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_generics.R, R/espn_standings.R,
%   R/flea_standings.R, R/mfl_standings.R, R/sleeper_standings.R
\name{ff_standings}
\alias{ff_standings}
\alias{ff_standings.espn_conn}
\alias{ff_standings.flea_conn}
\alias{ff_standings.mfl_conn}
\alias{ff_standings.sleeper_conn}
\title{Get Standings}
\usage{
ff_standings(conn, ...)

\method{ff_standings}{espn_conn}(conn, ...)

\method{ff_standings}{flea_conn}(conn, include_allplay = TRUE, include_potentialpoints = TRUE, ...)

\method{ff_standings}{mfl_conn}(conn, ...)

\method{ff_standings}{sleeper_conn}(conn, ...)
}
\arguments{
\item{conn}{a conn object created by \code{ff_connect()}}

\item{...}{arguments passed to other methods (currently none)}

\item{include_allplay}{TRUE/FALSE - return all-play win pct calculation? defaults to TRUE}

\item{include_potentialpoints}{TRUE/FALSE - return potential points calculation? defaults to TRUE.}
}
\value{
A tidy dataframe of standings data
}
\description{
This function returns a tidy dataframe of season-long fantasy team stats, including H2H wins as well as points, potential points, and all-play.
}
\section{Methods (by class)}{
\itemize{
\item \code{espn_conn}: ESPN: returns standings and points data.

\item \code{flea_conn}: Fleaflicker: returns H2H/points/all-play/best-ball data in a table.

\item \code{mfl_conn}: MFL: returns H2H/points/all-play/best-ball data in a table.

\item \code{sleeper_conn}: Sleeper: returns all standings and points data and manually calculates allplay results.
}}

\examples{
\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
  espn_conn <- espn_connect(season = 2020, league_id = 899513)
  ff_standings(espn_conn)
}) # end try
}

\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
conn <- fleaflicker_connect(season = 2020, league_id = 206154)
x <- ff_standings(conn)
}) # end try
}

\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
ssb_conn <- ff_connect(platform = "mfl", league_id = 54040, season = 2020)
ff_standings(ssb_conn)
}) # end try
}

\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
jml_conn <- ff_connect(platform = "sleeper", league_id = "522458773317046272", season = 2020)
ff_standings(jml_conn)
}) # end try
}

}
