% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_generics.R, R/flea_userleagues.R,
%   R/mfl_userleagues.R, R/sleeper_userleagues.R
\name{ff_userleagues}
\alias{ff_userleagues}
\alias{ff_userleagues.flea_conn}
\alias{ff_userleagues.mfl_conn}
\alias{ff_userleagues.sleeper_conn}
\title{Get User Leagues}
\usage{
ff_userleagues(conn, ...)

\method{ff_userleagues}{flea_conn}(conn = NULL, user_email = NULL, season = NULL, ...)

\method{ff_userleagues}{mfl_conn}(conn, season = NULL, ...)

\method{ff_userleagues}{sleeper_conn}(conn = NULL, user_name = NULL, season = NULL, ...)
}
\arguments{
\item{conn}{a connection object created by \code{ff_connect()}}

\item{...}{arguments that may be passed to other methods (for method consistency)}

\item{user_email}{the username to look up - defaults to user created in conn if available}

\item{season}{the season to look up leagues for}

\item{user_name}{the username to look up - defaults to user created in conn if available}
}
\value{
A tidy dataframe with one row for every league a user is in
}
\description{
This function returns a tidy dataframe with one row for every league a user is in. This requries authentication cookies for MFL usage.
}
\section{Methods (by class)}{
\itemize{
\item \code{flea_conn}: flea: returns a listing of leagues for a given user_email

\item \code{mfl_conn}: MFL: With username/password, it will return a list of user leagues.

\item \code{sleeper_conn}: Sleeper: returns a listing of leagues for a given user_id or user_name
}}

\seealso{
\code{\link{fleaflicker_userleagues}} to call this function for flea leagues without first creating a connection object.

\code{\link{sleeper_userleagues}} to call this function for Sleeper leagues without first creating a connection object.
}
