% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fermicatsR.R
\docType{data}
\name{FGL2}
\alias{FGL2}
\title{2FGL Catalog (Fermi Large Area Telescope Second Source Catalog)}
\format{A data frame with 137 variables on 1873 gamma-ray sources:}
\source{
\url{http://fermi.gsfc.nasa.gov/ssc/data/access/lat/2yr_catalog/}
}
\usage{
FGL2
}
\description{
Fermi Large Area Telescope Second Source Catalog (2FGL).
Nolan, P. L. et al., The Astrophysical Journal Supplement Series, 199, 31 (2012).
}
\details{
Initial Release: 11 July 2011
Latest Release: gll_psc_v09.fit (18 May 2015)
}
\section{Fields}{

\describe{
\item{Source_Name}{2FGL JHHMM.m+DDMM[c/e], constructed according to IAU Specifications for Nomenclature;
m is decimal minutes of R.A.; in the name R.A. and decl. are truncated at 0.1 decimal minutes and 1' ,
respectively; 'c' indicates that based on the region of the sky the source is considered to be potentially confused with
Galactic diffuse emission; e indicates a source that was modeled as spatially extended (see Section 3.4 of 2FGL paper)}
\item{RAJ2000}{Right Ascension, J2000, deg, three decimal places}
\item{DEJ2000}{Declination, J2000, deg, three decimal places}
\item{GLON}{Galactic longitude, deg, three decimal places}
\item{GLAT}{Galactic latitude, deg, three decimal places}
\item{Conf_68_SemiMajor}{Semimajor radius of 68\% confidence region, deg, three decimal places}
\item{Conf_68_SemiMinor}{Semiminor radius of 68\% confidence region, deg, three decimal places}
\item{Conf_68_PosAng}{Position angle of 68\% confidence region, deg. east of north, 0 decimal places}
\item{Conf_95_SemiMajor}{Semimajor radius of 95\% confidence region, deg, three decimal places}
\item{Conf_95_SemiMinor}{Semiminor radius of 95\% confidence region, deg, three decimal places}
\item{Conf_95_PosAng}{Position angle of 95\% confidence region, deg. east of north, 0 decimal places}
\item{Signif_Avg}{Significance derived from likelihood TS for 100 MeV\342\200\223100 GeV analysis, one decimal place}
\item{Pivot_Energy}{Energy at which error on differential flux is minimal, in MeV}
\item{Flux_density}{Differential flux at Pivot_Energy, in cm^{-2} MeV^{-1} s^{-1}}
\item{Unc_Flux_Density}{1 sigma error on differential flux at Pivot_Energy, in cm^{-2} MeV^{-1} s^{-1}}
\item{Spectral_Index}{Best-fit photon number power-law index. For LogParabola spectra, index at Pivot_Energy; for PLExpCutoff spectra, low-energy index.}
\item{Unc_Spectral_Index}{1 sigma error on Spectral_Index}
\item{Flux1000}{Integral flux from 1 to 100 GeV, in cm^{-2} s^{-1}}
\item{Unc_Flux1000}{1 sigma error on integral flux from 1 to 100 GeV, in cm^{-2} s^{-1}}
\item{Energy_Flux100}{Energy flux from 100 MeV to 100 GeV obtained by spectral fitting, in erg cm^{-2} s^{-1}}
\item{Unc_Energy_Flux}{1 sigma error on energy flux from 100 MeV to 100 GeV, in erg cm^{-2} s^{-1}}
\item{Signif_Curve}{Significance (in sigma units) of the fit improvement between power-law and either LogParabola (for ordinary sources) or PLExpCutoff (for pulsars). A value greater than 4 indicates significant curvature.}
\item{SpectrumType}{Spectral type (PowerLaw, LogParabola, PLExpCutoff)}
\item{beta}{Curvature parameter (Beta) for LogParabola. NULL for other spectral types}
\item{Unc_beta}{1 sigma error on Beta for LogParabola. NULL for other spectral types}
\item{Cutoff}{Cutoff energy as exp(-E/Cutoff) for PLExpCutoff, in MeV. NULL for other spectral types.}
\item{Unc_Cutoff}{1 sigma error on cutoff energy for PLExpCutoff, in MeV. NULL for other spectral types.}
\item{PowerLaw_Index}{Best-fit power-law index. Equal to Spectral_Index if SpectrumType is PowerLaw.}
\item{Flux30_100}{Integral flux from 30 to 100 MeV (not filled)}
\item{Unc_Flux30_100}{1 sigma error on integral flux from 30 to 100 MeV (not filled)}
\item{Sqrt_TS30_100}{Square root of the TS between 30 and 100 MeV (not filled)}
\item{Flux100_300}{Integral flux from 100 to 300 MeV, in cm^{-2} s^{-1}}
\item{Unc_Flux100_300}{1 sigma error on integral flux from 100 to 300 MeV, in cm^{-2} s^{-1}}
\item{Sqrt_TS100_300}{Square root of the TS between 100 to 300 MeV}
\item{Flux300_1000}{Integral flux from 100 to 300 MeV, in cm^{-2} s^{-1}}
\item{Unc_Flux300_1000}{1 sigma error on integral flux from 300 MeV to 1 GeV, in cm^{-2} s^{-1}}
\item{Sqrt_TS300_1000}{Square root of the TS between 300 MeV to 1 GeV}
\item{Flux1000_3000}{Integral flux from 1 to 3 GeV, in cm^{-2} s^{-1}}
\item{Unc_Flux1000_3000}{1 sigma error on integral flux from 1 to 3 GeV, in cm^{-2} s^{-1}}
\item{Sqrt_TS1000_3000}{Square root of the TS between 1 to 3 GeV}
\item{Flux3000_10000}{Integral flux from 3 to 10 GeV, in cm^{-2} s^{-1}}
\item{Unc_Flux3000_10000}{1 sigma error on integral flux from 3 to 10 GeV, in cm^{-2} s^{-1}}
\item{Sqrt_TS3000_10000}{Square root of the TS between 3 to 10 GeV}
\item{Flux10000_100000}{Integral flux from 10 to 100 GeV, in cm^{-2} s^{-1}}
\item{Unc_Flux10000_100000}{1 sigma error on integral flux from 10 to 100 GeV, in cm^{-2} s^{-1}}
\item{Sqrt_TS10000_100000}{Square root of the TS between 10 to 100 GeV}
\item{Variability_Index}{Sum of 2xLog(Likelihood) comparison between the flux fitted in 24 time segments and a flat light curve over the full two-year catalog interval. A value greater than 41.64 indicates < 1\% chance of being a steady source. }
\item{Signif_Peak}{Source significance in peak interval in sigma units}
\item{Flux_Peak}{Peak integral flux from 100 MeV to 100 GeV, in cm^{-2} s^{-1}}
\item{Unc_Flux_Peak}{1 sigma error on peak integral flux, in cm^{-2} s^{-1}}
\item{Time_Peak}{Time of center of interval in which peak flux was measured}
\item{Peak_Interval}{Length of interval in which peak flux was measured}
\item{Flux_History.1 ... Flux_History.24}{Integral flux from 100 MeV to 100 GeV in time interval 1 ... 24, in cm^{-2} s^{-1}}
\item{Unc_Flux_History.1 ... Unc_Flux_History.24}{Error on the integral flux from 100 MeV to 100 GeV in time interval 1 ... 24, in cm^{-2} s^{-1}, using the method indicated in Unc_Flag_History column and added in quatrature with 3\% systematic component.}
\item{Unc_Flag_History.1 ... Unc_Flag_History.24}{1 if it is half of the difference between the 2 sigma upper limit and the maximum likelihood value given in Flux_History; 0 if it is the 1 sigma uncertainty derived from a significant detection in the interval.}
\item{Extended_Source_Name}{Cross-reference to the ExtendedSources extension for extended sources, if any.}
\item{0FGL_Name}{Name of the corresponding 0FGL source, if any.}
\item{1FGL Name}{Name of the corresponding 1FGL source, if any.}
\item{ASSOC_GAM1}{Identification or positional associations with AGILE (1AGL)source}
\item{ASSOC_GAM2}{Identification or positional associations with 3EG source}
\item{ASSOC_GAM3}{Identification or positional associations with EGR source}
\item{TEVCAT_FLAG}{Positional association with a TeVCat source, P for angular size < 40', E for extended, N if no TeV association}
\item{ASSOC_TEV}{Name of likely corresponding TeV source from TevCat.}
\item{CLASS1}{Class designation for most likely association. Capital letters indicate firm identifications; lower-case letters indicate associations:
Pulsar, identified by pulsations (PSR), Pulsar, no pulsations seen in LAT yet (psr), Pulsar wind nebula (PWN), Supernova remnant (SNR), Supernova remnant/pulsar wind nebula (spp),
Globular cluster (glc), High-mass binary (HMB), Nova (NOV), Blazar of the BL Lac type (BZB), Blazar of the FSRQ type (BZQ), Non-blazar active galaxy (AGN), Radio galaxy (RDG),
Seyfert galaxy (SEY), Active galaxy of uncertain type (AGU), Normal galaxy (GAL), Starburst galaxy (sbg), Unassociated source (  ).}
\item{CLASS2}{2nd class designation for associated source.}
\item{ASSOC1}{Name of identified or likely associated source.}
\item{ASSOC2}{Alternate name of identified or likely associated source.}
\item{Flags}{Binary coding. See Table 3 of 2FGL paper for the definition of the various Analysis Flags.}
}
}
\keyword{datasets}

