% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guerrero.R
\name{guerrero}
\alias{guerrero}
\title{Guerrero's method for Box Cox lambda selection}
\usage{
guerrero(x, lower = -0.9, upper = 2, .period = 2L)
}
\arguments{
\item{x}{A numeric vector. The data used to identify the transformation
parameter lambda.}

\item{lower}{The lower bound for lambda.}

\item{upper}{The upper bound for lambda.}

\item{.period}{The length of each subseries (usually the length of seasonal
period). Subseries length must be at least 2.}
}
\value{
A Box Cox transformation parameter (lambda) chosen by Guerrero's method.
}
\description{
Applies Guerrero's (1993) method to select the lambda which minimises the
coefficient of variation for subseries of x.
}
\details{
Note that this function will give slightly different results to
\code{forecast::BoxCox.lambda(y)} if your data does not start at the start of the
seasonal period. This function will make use of all of your data, whereas the
forecast package will not use data that doesn't complete a seasonal period.
}
\references{
Box, G. E. P. and Cox, D. R. (1964) An analysis of transformations. JRSS B 26 211–246.

Guerrero, V.M. (1993) Time-series analysis supported by power transformations. Journal of Forecasting, 12, 37–48.
}
