% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardgeneticalgorithm.R
\name{geneticalgorithm}
\alias{geneticalgorithm}
\title{Standard Genetic Algorithm.
Implements a standard genetic algorithm using GA package (\link[GA]{ga}) with a fitness function specialised for feature selection.}
\usage{
geneticalgorithm(
  model = feamiR::svmlinear,
  k = 30,
  training,
  test,
  parallel = TRUE,
  mutprob = 0.1,
  crossprob = 0.8,
  popsize = 20,
  maxiter = 1000,
  maxiter_withoutimprovement = 300,
  numberpassedon = 3,
  plot = FALSE
)
}
\arguments{
\item{model}{The ML models used to classify the data, typically SVM with a given kernel}

\item{k}{Maximum number of features to be output.}

\item{training}{Training dataset as a data.frame with classification column and column for each feature.}

\item{test}{Test dataset with matching columns to training.}

\item{parallel}{Specifies whether GA should be run sequentially or in parallel (default: TRUE)}

\item{mutprob}{The probability that an individual undergoes mutation in a particular iteration (default: 0.1)}

\item{crossprob}{The probability of crossover between pairs of individuals (default: 0.8)}

\item{popsize}{The size of the solution population (default:20)}

\item{maxiter}{The maximum number of iterations to run before termination (default: 1000)}

\item{maxiter_withoutimprovement}{The maximum number of consecutive iterations without improvement to fitness before termination (default: 300)}

\item{numberpassedon}{The number of best fitness individuals to be passed on to the next generation in each iteration (default: 3)}

\item{plot}{Specifies whether GA plot should be shown (default: FALSE)}
}
\value{
Set (unordered) of <=k features and training and test accuracy, sensitivity and specificity using these features.
}
\description{
Standard Genetic Algorithm.
Implements a standard genetic algorithm using GA package (\link[GA]{ga}) with a fitness function specialised for feature selection.
}
\examples{
data_train = data.frame(
      classification=as.factor(c(1,1,0,0,1,1,0,0,1,1)),
      A=c(1,1,1,0,0,0,1,1,1,0),
      B=c(0,1,1,0,1,1,0,1,1,0),
      C=c(0,0,1,0,0,1,0,0,1,0),
      D=c(0,1,1,0,0,0,1,0,0,0),
      E=c(1,0,1,0,0,1,0,1,1,0))
data_test = data.frame(
      classification=as.factor(c(1,1,0,0,1,1,1,0)),
      A=c(0,0,0,1,0,0,0,1),
      B=c(1,1,1,0,0,1,1,1),
      C=c(0,0,1,1,0,0,1,1),
      D=c(0,0,1,1,0,1,0,1),
      E=c(0,0,1,0,1,0,1,1))
geneticalgorithm(
  feamiR::svmlinear,
  k=2,
  data_train,
  data_test,
  parallel=FALSE,
  maxiter=5,
  maxiter_withoutimprovement=5,
  popsize=10)
}
\keyword{feature}
\keyword{genetic}
\keyword{selection}
