% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\docType{class}
\name{em-class}
\alias{em-class}
\title{Expectation-Maximization model}
\description{
This class contains the model obtained by the EM method.
}
\section{Slots}{

\describe{
\item{\code{modelName}}{A character string indicating the model. The help file for \code{\link[mclust]{mclustModelNames}} describes the available models.}

\item{\code{prior}}{Specification of a conjugate prior on the means and variances.}

\item{\code{n}}{The number of observations in the dataset.}

\item{\code{d}}{The number of variables in the dataset.}

\item{\code{G}}{The number of components of the mixture.}

\item{\code{z}}{A matrix whose \code{[i,k]}th entry is the conditional probability of the ith observation belonging to the kth component of the mixture.}

\item{\code{parameters}}{A names list giving the parameters of the model.}

\item{\code{control}}{A list of control parameters for EM.}

\item{\code{loglik}}{The log likelihood for the data in the mixture model.}

\item{\code{cluster}}{A vector of integers (from \code{1:k}) indicating the cluster to which each point is allocated.}
}}

\seealso{
\code{\link{EM}}, \code{\link[mclust]{mclustModelNames}}
}
