% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{MEANSHIFT}
\alias{MEANSHIFT}
\title{MeanShift method}
\usage{
MEANSHIFT(d, kernel = "NORMAL", bandwidth = rep(1, ncol(d)),
  alpha = 0, iterations = 10, epsilon = 1e-08,
  epsilonCluster = 1e-04, ...)
}
\arguments{
\item{d}{The dataset (\code{matrix} or \code{data.frame}).}

\item{kernel}{A string indicating the kernel associated with the kernel density estimate that the mean shift is optimizing over.}

\item{bandwidth}{Used in the kernel density estimate for steepest ascent classification.}

\item{alpha}{A scalar tuning parameter for normal kernels.}

\item{iterations}{The number of iterations to perform mean shift.}

\item{epsilon}{A scalar used to determine when to terminate the iteration of a individual query point.}

\item{epsilonCluster}{A scalar used to determine the minimum distance between distinct clusters.}

\item{...}{Other parameters.}
}
\value{
The clustering (\code{meanshift} object).
}
\description{
Run MeanShift for clustering.
}
\examples{
require (datasets)
data (iris)
MEANSHIFT (iris [, -5], bandwidth = .75)
}
\seealso{
\code{\link[meanShiftR]{meanShift}}, \code{\link{predict.meanshift}}
}
