% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/association.R
\name{summary.apriori}
\alias{summary.apriori}
\title{Print summary of a classification model obtained by APRIORI}
\usage{
\method{summary}{apriori}(object, ...)
}
\arguments{
\item{object}{The model to be printed.}

\item{...}{Other parameters.}
}
\description{
Print summary of the set of rules in the classification model obtained by APRIORI.
}
\examples{
require ("datasets")
data (iris)
d = discretizeDF (iris,
    default = list (method = "interval", breaks = 3, labels = c ("small", "medium", "large")))
model = APRIORI (d [, -5], d [, 5], supp = .1, conf = .9, prune = TRUE)
summary (model)
}
\seealso{
\code{\link{APRIORI}}, \code{\link{predict.apriori}}, \code{\link{print.apriori}},
\code{\link{apriori-class}}, \code{\link[arules]{apriori}}
}
