% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.mesh.2D}
\alias{plot.mesh.2D}
\title{Plot a mesh.2D object}
\usage{
\method{plot}{mesh.2D}(x, ...)
}
\arguments{
\item{x}{A \code{mesh.2D} object defining the triangular mesh, as generated by \code{create.mesh.2D}
or \code{refine.mesh.2D}.}

\item{...}{Arguments representing graphical options to be passed to \link[graphics]{par}.}
}
\description{
Plot a mesh.2D object, generated by \code{create.mesh.2D} or \code{refine.mesh.2D}.
}
\examples{
library(fdaPDE)

## Upload the quasicirle2D data
data(quasicircle2D)
boundary_nodes = quasicircle2D$boundary_nodes
boundary_segments = quasicircle2D$boundary_segments
locations = quasicircle2D$locations
data = quasicircle2D$data

## Create mesh
mesh = create.mesh.2D(nodes = rbind(boundary_nodes, locations), segments = boundary_segments)

## Plot the mesh
plot(mesh)
}
