\name{inprod.fdata}
\Rdversion{1.1}
\alias{inprod.fdata}
\title{
Inner products of Functional Data Objects o class (fdata)
}
\description{	
Computes a inner products of functional data objects of class fdata.
}
\usage{
inprod.fdata(fdata1,fdata2=NULL, w = 1, ...)  
}
\arguments{  
  \item{fdata1}{Functional data 1 or curve 1. \code{fdata1$data} with dimension (\code{n1} x \code{m}), where \code{n1} is the number of curves and \code{m} are the points observed in each curve.}
  \item{fdata2}{Functional data 2 or curve 2. \code{fdata2$data} with dimension (\code{n2} x \code{m}), where \code{n2} is the number of curves and \code{m} are the points observed in each curve.}
  \item{w}{ Vector of weights with length \code{m}, If \code{w} = 1 approximates the metric Lp by Simpson's rule. By default it uses \code{w} = 1 }
  \item{\dots}{ Further arguments passed to or from other methods.}
}
\details{
By default it uses weights \code{w=1}. 
\deqn{ \left\langle fdata1,fdata2 \right\rangle=\frac{1}{\int_{a}^{b}w(x)dx} \int_{a}^{b} fdata1(x) * fdata2(x)w(x) dx }{}
The observed points on each curve are equally spaced (by default) or not. 
}
\author{
Febrero-Bande, M. and Oviedo de la Fuente, M.
}
\seealso{
See also   \link[fda]{inprod} and \code{\link{norm.fdata}}
} 
\examples{

x<-seq(0,2*pi,length=1001)
fx1<-sin(x)/sqrt(pi)
fx2<-cos(x)/sqrt(pi)
argv<-seq(0,2*pi,len=1001)
fdat0<-fdata(rep(0,len=1001),argv,range(argv))
fdat1<-fdata(fx1,x,range(x))
inprod.fdata(fdat1,fdat1)
inprod.fdata(fdat1,fdat1)
metric.lp(fdat1)
metric.lp(fdat1,fdat0)
norm.fdata(fdat1)
# The same
integrate(function(x){(abs(sin(x)/sqrt(pi))^2)},0,2*pi)
integrate(function(x){(abs(cos(x)/sqrt(pi))^2)},0,2*pi)
}
\keyword{cluster}