% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fbroc.roc.R
\name{calculate.thresholds}
\alias{calculate.thresholds}
\title{Calculates ROC curve thresholds}
\usage{
calculate.thresholds(pred, true.class)
}
\arguments{
\item{pred}{A numeric vector. Contains predictions. \code{calculate.thresholds}
assumes that a high prediction is evidence for the observation belonging
to the positive class.}

\item{true.class}{A logical vector. TRUE indicates the sample belonging to the
positive class.}
}
\value{
A numeric vector containing the thresholds. The length of the vector
  depends on the data. The number of thresholds tends to go down as the
  performance of the clasifier improves.
}
\description{
\code{calculate.thresholds} calculates the thresholds of the ROC curve
at which the curve changes directions.
}
\examples{
x <- 1:10
y <- c(FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, TRUE, TRUE, TRUE, TRUE)
calculate.thresholds(x, y) # relevant thresholds are 1, 4, 5, 7, 11
}

