% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errors-children.R
\docType{data}
\name{Error-Classes}
\alias{Error-Classes}
\alias{HTTPAccepted}
\alias{HTTPAlreadyReported}
\alias{HTTPAuthenticationTimeout}
\alias{HTTPBadGateway}
\alias{HTTPBadRequest}
\alias{HTTPBandwidthLimitExceeded}
\alias{HTTPBlockedByWindowsParentalControls}
\alias{HTTPCertError}
\alias{HTTPClientClosedRequest}
\alias{HTTPConflict}
\alias{HTTPContinue}
\alias{HTTPCreated}
\alias{HTTPExpectationFailed}
\alias{HTTPFailedDependency}
\alias{HTTPForbidden}
\alias{HTTPFound}
\alias{HTTPGatewayTimeout}
\alias{HTTPGone}
\alias{HTTPHTTPToHTTPS}
\alias{HTTPHTTPVersionNotSupported}
\alias{HTTPImUsed}
\alias{HTTPInsufficientStorage}
\alias{HTTPInternalServerError}
\alias{HTTPLengthRequired}
\alias{HTTPLocked}
\alias{HTTPLoginTimeout}
\alias{HTTPLoopDetected}
\alias{HTTPMethodFailure}
\alias{HTTPMethodNotAllowed}
\alias{HTTPMovedPermanently}
\alias{HTTPMultiStatus}
\alias{HTTPMultipleChoices}
\alias{HTTPNetworkAuthenticationRequired}
\alias{HTTPNetworkConnectTimeoutError}
\alias{HTTPNetworkReadTimeoutError}
\alias{HTTPNoCert}
\alias{HTTPNoContent}
\alias{HTTPNoResponse}
\alias{HTTPNonAuthoritativeInformation}
\alias{HTTPNotAcceptable}
\alias{HTTPNotExtended}
\alias{HTTPNotFound}
\alias{HTTPNotImplemented}
\alias{HTTPNotModified}
\alias{HTTPOK}
\alias{HTTPPartialContent}
\alias{HTTPPaymentRequired}
\alias{HTTPPermanentRedirect}
\alias{HTTPPreconditionFailed}
\alias{HTTPPreconditionRequired}
\alias{HTTPProcessing}
\alias{HTTPProxyAuthenticationRequired}
\alias{HTTPRequestEntityTooLarge}
\alias{HTTPRequestHeaderFieldsTooLarge}
\alias{HTTPRequestHeaderTooLarge}
\alias{HTTPRequestRangeNotSatisfiable}
\alias{HTTPRequestTimeout}
\alias{HTTPRequestURITooLong}
\alias{HTTPResetContent}
\alias{HTTPRetryWith}
\alias{HTTPSeeOther}
\alias{HTTPServiceUnavailable}
\alias{HTTPSwitchProtocol}
\alias{HTTPSwitchProxy}
\alias{HTTPTeaPot}
\alias{HTTPTemporaryRedirect}
\alias{HTTPTokenExpiredInvalid}
\alias{HTTPTooManyRequests}
\alias{HTTPUnauthorized}
\alias{HTTPUnavailableForLegalReasons}
\alias{HTTPUnorderedCollection}
\alias{HTTPUnprocessableEntity}
\alias{HTTPUnsupportedMediaType}
\alias{HTTPUpgradeRequired}
\alias{HTTPUseProxy}
\alias{HTTPVariantAlsoNegotiates}
\title{Individual error classes}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
HTTPContinue

HTTPSwitchProtocol

HTTPProcessing

HTTPOK

HTTPCreated

HTTPAccepted

HTTPNonAuthoritativeInformation

HTTPNoContent

HTTPResetContent

HTTPPartialContent

HTTPMultiStatus

HTTPAlreadyReported

HTTPImUsed

HTTPMultipleChoices

HTTPMovedPermanently

HTTPFound

HTTPSeeOther

HTTPNotModified

HTTPUseProxy

HTTPSwitchProxy

HTTPTemporaryRedirect

HTTPPermanentRedirect

HTTPBadRequest

HTTPUnauthorized

HTTPPaymentRequired

HTTPForbidden

HTTPNotFound

HTTPMethodNotAllowed

HTTPNotAcceptable

HTTPProxyAuthenticationRequired

HTTPRequestTimeout

HTTPConflict

HTTPGone

HTTPLengthRequired

HTTPPreconditionFailed

HTTPRequestEntityTooLarge

HTTPRequestURITooLong

HTTPUnsupportedMediaType

HTTPRequestRangeNotSatisfiable

HTTPExpectationFailed

HTTPTeaPot

HTTPAuthenticationTimeout

HTTPMethodFailure

HTTPUnprocessableEntity

HTTPLocked

HTTPFailedDependency

HTTPUnorderedCollection

HTTPUpgradeRequired

HTTPPreconditionRequired

HTTPTooManyRequests

HTTPRequestHeaderFieldsTooLarge

HTTPLoginTimeout

HTTPNoResponse

HTTPRetryWith

HTTPBlockedByWindowsParentalControls

HTTPUnavailableForLegalReasons

HTTPRequestHeaderTooLarge

HTTPCertError

HTTPNoCert

HTTPHTTPToHTTPS

HTTPTokenExpiredInvalid

HTTPClientClosedRequest

HTTPInternalServerError

HTTPNotImplemented

HTTPBadGateway

HTTPServiceUnavailable

HTTPGatewayTimeout

HTTPHTTPVersionNotSupported

HTTPVariantAlsoNegotiates

HTTPInsufficientStorage

HTTPLoopDetected

HTTPBandwidthLimitExceeded

HTTPNotExtended

HTTPNetworkAuthenticationRequired

HTTPNetworkReadTimeoutError

HTTPNetworkConnectTimeoutError
}
\description{
These error classes are for each HTTP error, and inherit from
the \code{\link{Error}} class in this package.
}
\details{
In addition to what's available in \code{\link{Error}},
these classes have a single variable \code{mssg} that is the very
verbose complete message describing the HTTP condition in detail.
You can include that message in your condition by using \code{do_verbose}
(see below)

\strong{Methods}
\itemize{
  \item \code{do_verbose(response)}
  \code{response} is any response from \pkg{crul}, \pkg{curl}, or \pkg{httr}
  Execute condition, whether it be message, warning, error, or your
  own custom function.
}
}
\examples{
if (requireNamespace("crul")) {

 library("crul")
 res <- HttpClient$new("https://httpbin.org/status/414")$get()
 x <- HTTPRequestURITooLong$new()
 \dontrun{
 x$do(res)
 x$do_verbose(res)
 }

 # behavior
 x <- HTTPRequestURITooLong$new(behavior = "warning")
 \dontrun{
 x$do(res)
 x$do_verbose(res)
 }

 x <- HTTPRequestURITooLong$new(behavior = "message")
 \dontrun{
 x$do(res)
 x$do_verbose(res)
 }

 # with message template
 x <- HTTPRequestURITooLong$new(
   message_template = "{{reason}} ............ {{status}}"
 )
 \dontrun{
 x$do(res)
 x$do_verbose(res)
 }
}

}
\seealso{
\code{\link[fauxpas]{Error}}, \code{\link[fauxpas]{http}}
}
\keyword{datasets}

