% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/API.R
\name{get_nn}
\alias{get_nn}
\title{Get nearest neighbour vectors}
\usage{
get_nn(model, word, k)
}
\arguments{
\item{model}{trained fastText model. Null if train a new model.}

\item{word}{reference word}

\item{k}{\link{integer} defining the number of results to return}
}
\value{
\link{numeric} with distances with \link{names} as words
}
\description{
Find the \code{k} words with the smallest distance.
First execution can be slow because of precomputation.
Search is done linearly, if your model is big you may want to use an approximate neighbour algorithm from other R packages (like RcppAnnoy).
}
\examples{

library(fastrtext)
model_test_path <- system.file("extdata", "model_unsupervised_test.bin", package = "fastrtext")
model <- load_model(model_test_path)
get_nn(model, "time", 10)

}
