% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params_helpers.R
\name{get_default_tune_params}
\alias{get_default_tune_params}
\title{Get Default Tuning Parameters}
\usage{
get_default_tune_params(algo, train_data, label, engine)
}
\arguments{
\item{algo}{A character string specifying the algorithm name. Supported values include: \code{"rand_forest"}, \code{"C5_rules"}, \code{"xgboost"}, \code{"lightgbm"}, \code{"logistic_reg"}, \code{"multinom_reg"}, \code{"decision_tree"}, \code{"svm_linear"}, \code{"svm_rbf"}, \code{"nearest_neighbor"}, \code{"naive_Bayes"}, \code{"mlp"}, \code{"deep_learning"}, \code{"discrim_linear"}, \code{"discrim_quad"}, \code{"bag_tree"}, \code{"elastic_net"}, \code{"bayes_glm"}, \code{"pls"}, \code{"linear_reg"}, \code{"ridge_regression"}, and \code{"lasso_regression"}.}

\item{train_data}{A data frame containing the training data.}

\item{label}{A character string specifying the name of the outcome variable in \code{train_data}. This column is excluded when calculating the number of predictors.}

\item{engine}{A character string specifying the engine to be used for the algorithm. Different engines may have different tuning parameter ranges.}
}
\value{
A list of tuning parameter ranges for the specified algorithm. If no tuning parameters are defined for the given algorithm, the function returns \code{NULL}.
}
\description{
Returns a list of default tuning parameter ranges for a specified algorithm based on the provided training data, outcome label, and engine.
}
\details{
The function first determines the number of predictors by removing the outcome variable (specified by \code{label}) from \code{train_data}. It then uses a \code{switch} statement to select a list of default tuning parameter ranges tailored for the specified algorithm and engine. The tuning ranges have been adjusted for efficiency and may include parameters such as \code{mtry}, \code{trees}, \code{min_n}, and others depending on the algorithm.
}
