% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/madPpt.r
\docType{data}
\name{madPpt}
\alias{madPpt}
\title{Rasters of average monthly precipitation for an eastern portion of Madagascar}
\format{
An object of class \code{SpatRaster}.
}
\source{
\doi{https://dx.doi.org/10.1002/joc.5086}
}
\description{
Rasters of precipitation for an eastern portion of Madagascar from WorldClim 2.1 at ~3.33 arcminute resolution projected to the Tananarive (Paris)/Laborde Grid coordinate reference system. Values represent monthly averages across 1970-2000. Units are in millimeters. These should not be used for formal analysis.
}
\examples{

### vector data

library(sf)

# For vector data, we can use data(*) or fastData(*):
data(madCoast0) # same as next line
madCoast0 <- fastData("madCoast0") # same as previous
madCoast0
plot(st_geometry(madCoast0))

madCoast4 <- fastData("madCoast4")
madCoast4
plot(st_geometry(madCoast4), add = TRUE)

madRivers <- fastData("madRivers")
madRivers
plot(st_geometry(madRivers), col = "blue", add = TRUE)

madDypsis <- fastData("madDypsis")
madDypsis
plot(st_geometry(madDypsis), col = "red", add = TRUE)

### raster data

library(terra)

# For raster data, we can get the file directly or using fastData(*):
rastFile <- system.file("extdata/madElev.tif", package="fasterRaster")
madElev <- terra::rast(rastFile)

madElev <- fastData("madElev") # same as previous two lines
madElev
plot(madElev)

madForest2000 <- fastData("madForest2000")
madForest2000
plot(madForest2000)

madForest2014 <- fastData("madForest2014")
madForest2014
plot(madForest2014)

# multi-layer rasters
madChelsa <- fastData("madChelsa")
madChelsa
plot(madChelsa)

madPpt <- fastData("madPpt")
madTmin <- fastData("madTmin")
madTmax <- fastData("madTmax")
madPpt
madTmin
madTmax


# RGB raster
madLANDSAT <- fastData("madLANDSAT")
madLANDSAT
plotRGB(madLANDSAT, 4, 1, 2, stretch = "lin")

# categorical raster
madCover <- fastData("madCover")
madCover
madCover <- droplevels(madCover)
levels(madCover) # levels in the raster
nlevels(madCover) # number of categories
catNames(madCover) # names of categories table

plot(madCover)
}
\references{
Fick, S.E. and Hijmans, R.J.  2017.  WorldClim 2: New 1-km spatial resolution climate surfaces for global land areas.  International Journal of Climatology 37:4302-4315. \doi{10.1002/joc.5086}
}
\keyword{Madagascar}
\keyword{climate}
