% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crds.r
\name{crds,GRaster-method}
\alias{crds,GRaster-method}
\alias{crds}
\alias{crds,GVector-method}
\alias{st_coordinates}
\title{Coordinates of a vector"s features or a raster"s cell centers}
\usage{
\S4method{crds}{GRaster}(x, z = is.3d(x), na.rm = TRUE)

\S4method{crds}{GVector}(x, z = is.3d(x))

st_coordinates(x)
}
\arguments{
\item{x}{A \code{GVector} or a \code{GRaster}.}

\item{z}{If \code{TRUE} (default), return x-, y-, and z-coordinates. If \code{FALSE}, just return x- and y-coordinates. For 2-dimensional objects, z-coordinates will all be 0.}

\item{na.rm}{Logical: If \code{TRUE}, remove cells that are \code{NA} (\code{GRaster}s only).}
}
\value{
A \code{matrix}, \code{data.frame}, or \code{list}.
}
\description{
Returns the coordinates of the center of cells of a \code{GRaster} or coordinates of a \code{GVector}'s vertices. The output will be a \code{matrix}, \code{data.frame}, or \code{list}. If you want the output to be a "points" \code{GVector}, use \code{\link[=as.points]{as.points()}}.
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Plant specimens (points), elevation (raster)
madDypsis <- fastData("madDypsis")
madElev <- fastData("madElev")

# Convert a SpatRaster to a GRaster, and sf to a GVector
dypsis <- fast(madDypsis)
elev <- fast(madElev)

### Get coordinates:
dypsisPoints <- crds(dypsis)
elevPoints <- crds(elev)

head(dypsisPoints)
head(elevPoints)

}
}
\seealso{
\code{\link[terra:crds]{terra::crds()}}
}
