% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addons.r
\name{addons}
\alias{addons}
\title{Test if addons directory exists and if an addon is installed}
\usage{
addons(x = NULL, fail = TRUE, verbose = TRUE)
}
\arguments{
\item{x}{Either \code{NULL} or a character specifying the name of a \strong{GRASS} addons module. If \code{NULL}, the existence of the \code{addonsDir} (see \code{\link[=faster]{faster()}}) will be tested. If the module name is provided, the existence of the folder and module will be tested. The "\verb{/bin}" subfolder should not be included.}

\item{fail}{Logical: If \code{TRUE} (default), and the addons folder is not correctly specified, the exit the function with an error. If \code{FALSE}, then \code{NULL} will be returned with a warning.}

\item{verbose}{Logical: If \code{TRUE} (default), display a message on success or warning (the \code{fail} option always displays a message).}
}
\value{
Logical.
}
\description{
This function tests to see if the "addons" directory specified using \code{\link[=faster]{faster()}} actually exists, and if a particular \strong{GRASS} \verb{addons module is available. The }addons\verb{folder and module must exists for methods that rely on particular **GRASS**}addons\verb{to work. See}vignette("addons", package = "fasterRaster")`.
}
\examples{
if (grassStarted()) {

# Does the addons folder exist?
ao <- addons(fail = "warning")
if (ao) print("Addons is folder is probably correctly specified.")

# Does this particular module exist?
addon <- "v.centerpoint"
exten <- addons(addon, fail = FALSE)

if (exten) print("Extension `v.centerpoints` is installed.")

}
}
\seealso{
\code{vignette("addons", package = "fasterRaster")}
}
