% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastcpd-class.R
\docType{class}
\name{fastcpd-class}
\alias{fastcpd-class}
\title{An S4 class to store the output created with \link{fastcpd}}
\description{
This S4 class stores the output from \link{fastcpd}. A fastcpd object consist
of several slots including the call to \link{fastcpd}, the data used, the
family of the model, the change points, the cost values, the residuals, the
estimated parameters and a boolean indicating whether the model was fitted
with only change points or with change points and parameters, which you can
select using \code{@}.
}
\section{Slots}{

\describe{
\item{\code{call}}{The call to \link{fastcpd}.}

\item{\code{data}}{The data used.}

\item{\code{family}}{The family of the model.}

\item{\code{cp_set}}{The change points.}

\item{\code{cost_values}}{The cost values for each segment.}

\item{\code{residuals}}{The residuals for each segment.}

\item{\code{thetas}}{The estimated parameters for each segment.}

\item{\code{cp_only}}{A boolean indicating whether \link{fastcpd} was run to return
only the change points or the change points with the estimated parameters
and cost values for each segment.}
}}

