% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_ops.R
\name{aug_transforms}
\alias{aug_transforms}
\title{Augmentation}
\usage{
aug_transforms(
  mult = 1,
  do_flip = TRUE,
  flip_vert = FALSE,
  max_rotate = 10,
  min_zoom = 1,
  max_zoom = 1.1,
  max_lighting = 0.2,
  max_warp = 0.2,
  p_affine = 0.75,
  p_lighting = 0.75,
  xtra_tfms = NULL,
  size = NULL,
  mode = "bilinear",
  pad_mode = "reflection",
  align_corners = TRUE,
  batch = FALSE,
  min_scale = 1
)
}
\arguments{
\item{mult}{ratio}

\item{do_flip}{to do flip}

\item{flip_vert}{flip vertical or not}

\item{max_rotate}{maximum rotation}

\item{min_zoom}{minimum zoom}

\item{max_zoom}{maximum zoom}

\item{max_lighting}{maximum lighting}

\item{max_warp}{maximum warp}

\item{p_affine}{probability affine}

\item{p_lighting}{probability lighting}

\item{xtra_tfms}{extra transformations}

\item{size}{size of image}

\item{mode}{mode}

\item{pad_mode}{padding mode}

\item{align_corners}{align_corners}

\item{batch}{batch size}

\item{min_scale}{minimum scale}
}
\value{
None
}
\description{
Utility func to easily create a list of flip, rotate, zoom, warp, lighting transforms.
}
\examples{

\dontrun{

URLs_PETS()

path = 'oxford-iiit-pet'

path_img = 'oxford-iiit-pet/images'
fnames = get_image_files(path_img)

dls = ImageDataLoaders_from_name_re(
path, fnames, pat='(.+)_.jpg$',
item_tfms=Resize(size = 460), bs = 10,
batch_tfms=list(aug_transforms(size = 224, min_scale = 0.75),
                Normalize_from_stats( imagenet_stats() )
)
)

}

}
