% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icevision_albumentations.R
\name{icevision_FDA}
\alias{icevision_FDA}
\title{FDA}
\usage{
icevision_FDA(
  reference_images,
  beta_limit = 0.1,
  read_fn = icevision_read_rgb_image(),
  always_apply = FALSE,
  p = 0.5
)
}
\arguments{
\item{reference_images}{reference_images}

\item{beta_limit}{beta_limit}

\item{read_fn}{read_fn}

\item{always_apply}{always_apply}

\item{p}{p}
}
\value{
None
}
\description{
Fourier Domain Adaptation from https://github.com/YanchaoYang/FDA
}
\details{
Simple "style transfer".
}
\section{Fourier Domain Adaptation from https}{
//github.com/YanchaoYang/FDA:
Simple "style transfer".
}

\section{Targets}{

image
}

\section{Image types}{

uint8, float32
}

\section{Reference}{

https://github.com/YanchaoYang/FDA https://openaccess.thecvf.com/content_CVPR_2020/papers/Yang_FDA_Fourier_Domain_Adaptation_for_Semantic_Segmentation_CVPR_2020_paper.pdf
}

\section{Example}{

>>> import numpy as np
>>> import albumentations as A
>>> image = np.random.randint(0, 256, [100, 100, 3], dtype=np.uint8)
>>> target_image = np.random.randint(0, 256, [100, 100, 3], dtype=np.uint8)
>>> aug = A.Compose([A.FDA([target_image], p=1, read_fn=lambda x: x)])
>>> result = aug(image=image)
}

