% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabel.one.R
\name{table_one}
\alias{table_one}
\title{Get Summary Table}
\usage{
table_one(
  data,
  group,
  mean_sd,
  median_q4,
  median_range,
  count_percent,
  mean,
  median,
  max,
  min,
  sd,
  q25,
  q75,
  count,
  percent,
  round = 2,
  count.percent.direction = "v",
  t.test,
  anova,
  wilcox.test,
  kruskal.test,
  chisq.test,
  fisher.test,
  weighted,
  statistics = FALSE
)
}
\arguments{
\item{data}{data that will be summarized}

\item{group}{one or more group variable names}

\item{mean_sd}{variable names for mand and standard deviation. in the results represents plus and minus}

\item{median_q4}{variable names for median and 25 and 75 quantiles}

\item{median_range}{variable names for median and range}

\item{count_percent}{variable names for count and percentage}

\item{mean}{variable names for mean}

\item{median}{variable names for median}

\item{max}{variable names for max}

\item{min}{variable names for min}

\item{sd}{variable names for standard deviation}

\item{q25}{variable names for 25 quantile}

\item{q75}{variable names for 75 quantile}

\item{count}{variable names for count}

\item{percent}{variable names for percentage}

\item{round}{digital round. 2 is defaulted}

\item{count.percent.direction}{calculate of direction for count, percent and count_percent arguments, which should be one of g, group, v or var, v as defaulted}

\item{t.test}{two-side t test}

\item{anova}{two-side anova}

\item{wilcox.test}{two-side wilcox test}

\item{kruskal.test}{two-side kruskal test}

\item{chisq.test}{two-side chisq test}

\item{fisher.test}{two-side fisher test}

\item{weighted}{weight for data}

\item{statistics}{a logical object. TRUE to display the statistic information. Default is FALSE}
}
\value{
a summary matrix
}
\description{
Get the first summary table when study.
}
\examples{
table_one(data = mtcars,group='vs',
          mean_sd = 'wt',
          count_percent  = c('gear','am')
)

table_one(data = mtcars,
group='vs',

mean_sd = 'wt',
t.test = 'wt',

count_percent  = c('gear','am','cyl'),
chisq.test = c('am','gear'),
fisher.test = c('cyl'),

round = 3
)
}
