% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emlinklog.R
\name{emlinklog}
\alias{emlinklog}
\title{emlinklog}
\usage{
emlinklog(patterns, nobs.a, nobs.b, p.m, p.gamma.j.m, p.gamma.j.u,
iter.max, tol, varnames)
}
\arguments{
\item{patterns}{table that holds the counts for each unique agreement
pattern. This object is produced by the function: tableCounts.}

\item{nobs.a}{Number of observations in dataset A}

\item{nobs.b}{Number of observations in dataset B}

\item{p.m}{probability of finding a match. Default is 0.1}

\item{p.gamma.j.m}{probability that conditional of being in the matched set we observed a specific agreement pattern.}

\item{p.gamma.j.u}{probability that conditional of being in the non-matched set we observed a specific agreement pattern.}

\item{iter.max}{Max number of iterations. Default is 5000}

\item{tol}{Convergence tolerance. Default is 1e-05}

\item{varnames}{The vector of variable names used for matching. Automatically provided if using \code{fastLink()} wrapper. Used for
clean visualization of EM results in summary functions.}
}
\value{
\code{emlinklog} returns a list with the following components:
\item{zeta.j}{The posterior match probabilities for each unique pattern.}
\item{p.m}{The probability of finding a match.}
\item{p.u}{The probability of finding a non-match.}
\item{p.gamma.j.m}{The probability of observing a particular agreement pattern conditional on being in the set of matches.}
\item{p.gamma.j.u}{The probability of observing a particular agreement pattern conditional on being in the set of non-matches.}
\item{patterns.w}{Counts of the agreement patterns observed, along with the Felligi-Sunter Weights.}
\item{iter.converge}{The number of iterations it took the EM algorithm to converge.}
\item{nobs.a}{The number of observations in dataset A.}
\item{nobs.b}{The number of observations in dataset B.}
}
\description{
Expectation-Maximization algorithm for Record Linkage 
allowing for dependencies across linkage fields
}
\examples{
\dontrun{
## Calculate gammas
g1 <- gammaCKpar(dfA$firstname, dfB$firstname)
g2 <- gammaCKpar(dfA$middlename, dfB$middlename)
g3 <- gammaCKpar(dfA$lastname, dfB$lastname)
g4 <- gammaKpar(dfA$birthyear, dfB$birthyear)

## Run tableCounts
tc <- tableCounts(list(g1, g2, g3, g4), nobs.a = nrow(dfA), nobs.b = nrow(dfB))

## Run EM
em.log <- emlinklog(tc, nobs.a = nrow(dfA), nobs.b = nrow(dfB))
}

}
\author{
Ted Enamorado <ted.enamorado@gmail.com> and Benjamin Fifield
}
