% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dummy_cols.R
\name{dummy_columns}
\alias{dummy_columns}
\title{Fast creation of dummy variables}
\usage{
dummy_columns(
  .data,
  select_columns = NULL,
  remove_first_dummy = FALSE,
  remove_most_frequent_dummy = FALSE,
  ignore_na = FALSE,
  split = NULL,
  remove_selected_columns = FALSE
)
}
\arguments{
\item{.data}{An object with the data set you want to make dummy columns from.}

\item{select_columns}{Vector of column names that you want to create dummy variables from.
If NULL (default), uses all character and factor columns.}

\item{remove_first_dummy}{Removes the first dummy of every variable such that only n-1 dummies remain.
This avoids multicollinearity issues in models.}

\item{remove_most_frequent_dummy}{Removes the most frequently observed category such that only n-1 dummies
remain. If there is a tie for most frequent, will remove the first
(by alphabetical order) category that is tied for most frequent.}

\item{ignore_na}{If TRUE, ignores any NA values in the column. If FALSE (default), then it
will make a dummy column for value_NA and give a 1 in any row which has a
NA value.}

\item{split}{A string to split a column when multiple categories are in the cell. For
example, if a variable is Pets and the rows are "cat", "dog", and "turtle",
each of these pets would become its own dummy column. If one row is "cat, dog",
then a split value of "," this row would have a value of 1 for both the cat
and dog dummy columns.}

\item{remove_selected_columns}{If TRUE (not default), removes the columns used to generate the dummy columns.}
}
\description{
dummy_columns() quickly creates dummy (binary) columns from character and
factor type columns in the inputted data. This function is useful for
statistical analysis when you want binary columns rather than
character columns.
}
\examples{
crime <- data.frame(city = c("SF", "SF", "NYC"),
    year = c(1990, 2000, 1990),
    crime = 1:3)
dummy_cols(crime)
# Include year column
dummy_cols(crime, select_columns = c("city", "year"))
# Remove first dummy for each pair of dummy columns made
dummy_cols(crime, select_columns = c("city", "year"),
    remove_first_dummy = TRUE)
}
\seealso{
\code{\link{dummy_rows}} For creating dummy rows

Other dummy functions: 
\code{\link{dummy_cols}()},
\code{\link{dummy_rows}()}
}
\concept{dummy functions}
