/*
 * Decompiled with CFR 0.152.
 */
package jfm.xml;

import jfm.lp.LPX;
import jfm.model.Machine;
import jfm.model.Types;
import jfm.xml.JFMObjectParser;
import jfm.xml.ObjectParser;
import jfm.xml.XMLObjectException;
import jfm.xml.XMLSyntaxException;

final class MachineParser
extends JFMObjectParser {
    Types.WorkerType type;

    public MachineParser(ObjectParser parent_) {
        this.parent = parent_;
        this.registerAttribute("wktype", JFMObjectParser.mandatoryAttribute);
        this.registerAttribute("cost", JFMObjectParser.mandatoryAttribute);
        this.registerAttribute("replace", JFMObjectParser.mandatoryAttribute);
        this.registerAttribute("depreciationRate", JFMObjectParser.mandatoryAttribute);
        this.registerAttribute("repairCosts", JFMObjectParser.mandatoryAttribute);
        this.registerAttribute("glpkV", JFMObjectParser.optionalAttribute);
    }

    public void initializeObject() throws XMLSyntaxException, XMLObjectException {
        try {
            this.type = Types.xmlToWorkerType(this.getNamedAttribute("wktype"));
            double cost = Double.parseDouble(this.getNamedAttribute("cost"));
            int replace = Integer.parseInt(this.getNamedAttribute("replace"));
            double depRate = Double.parseDouble(this.getNamedAttribute("depreciationRate"));
            double repair = Double.parseDouble(this.getNamedAttribute("repairCosts"));
            LPX glpkVType = this.attributeHasValue("glpkV") ? LPX.xmlToGLPKType(this.getNamedAttribute("glpkV")) : LPX.LPX_CV;
            this.obj = new Machine(this.type, cost, replace, depRate, repair, glpkVType);
        }
        catch (XMLSyntaxException tex) {
            tex.printStackTrace();
            throw new XMLSyntaxException(tex.getMessage());
        }
    }

    public String toString() {
        return "MachineParser";
    }

    public String parsesNode() {
        return "machine";
    }

    public String name() {
        if (this.type != null) {
            return this.type.xmlname;
        }
        if (this.attributeHasValue("type")) {
            try {
                return this.getNamedAttribute("type");
            }
            catch (XMLObjectException ex) {
                throw new Error(ex.getMessage());
            }
        }
        return "machine";
    }

    protected boolean isPrimitive() {
        return false;
    }
}

