/*
 * Decompiled with CFR 0.152.
 */
package jfm.model;

import jfm.lp.ConstraintBuilder;
import jfm.lp.LPX;
import jfm.lp.MatrixElement;
import jfm.lp.MatrixRow;
import jfm.lp.ModelComponent;
import jfm.lp.SOS2Primitive;
import jfm.model.BoundaryComponent;
import jfm.model.Types;

public class HedgerowLengthComponent
extends BoundaryComponent {
    public HedgerowLengthComponent(double maxLen_, double hist, double createCost, double destCost, double maintain, double discountRate_) {
        super(ModelComponent.MCType.HEDGEROWS, Types.ObjectiveType.HEDGEROWS, maxLen_, hist, createCost, destCost, maintain, discountRate_);
        this.addConstraintBuilder(new HedgerowSOS2Constraints(ConstraintBuilder.CBType.HEDGEROWSOS2, ModelComponent.MCType.HEDGEROWS));
    }

    public class HedgerowSOS2Constraints
    extends ConstraintBuilder {
        public HedgerowSOS2Constraints(ConstraintBuilder.CBType type_, ModelComponent.MCType assoc) {
            super(type_, assoc);
        }

        public void build() {
            SOS2Primitive.buildConstraints(HedgerowLengthComponent.this.profit, HedgerowLengthComponent.this.matrix);
            if (HedgerowLengthComponent.this.curve != null) {
                SOS2Primitive.buildLink(HedgerowLengthComponent.this.curve, HedgerowLengthComponent.this.profit, HedgerowLengthComponent.this.matrix);
            } else {
                int row = HedgerowLengthComponent.this.matrix.numRows();
                MatrixRow rowpointer = new MatrixRow(0.0, 0.0, LPX.LPX_FX, row, "BindHedges", "BindingRow");
                HedgerowLengthComponent.this.matrix.addRow(rowpointer);
                ++row;
                rowpointer.addElement(new MatrixElement(HedgerowLengthComponent.this.profit.getDependentColumn(0), -1.0));
                rowpointer.addElement(new MatrixElement(HedgerowLengthComponent.this.lengthCounter.column(), 1.0));
                HedgerowLengthComponent.this.matrix.flagForAlwaysRebuild();
            }
        }
    }
}

